/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class ErrorModifierProfile
extends AbstractModifierProfile {
    private String myExceptionMessage;
    private String myInitializationFailureMessage;
    private long myLogNumber;

    public ErrorModifierProfile(String modifierName, Exception exception) {
        this.myName = modifierName;
        this.myLogNumber = ExceptionUtil.handleException(exception, "ratingRuleFrame", 1, "Failed to initialize " + this.myName + " modifier.", false);
        this.myExceptionMessage = exception.getMessage();
        this.myInitializationFailureMessage = "Failed to initialize the " + this.getName() + " modifier.";
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(new NotAllowedVariable("", this.myInitializationFailureMessage));
        if (this.stringNotNull(this.myExceptionMessage)) {
            vars.add(new NotAllowedVariable("", "Error message: " + this.myExceptionMessage));
        }
        vars.add(new NotAllowedVariable("", "See log entry " + this.myLogNumber + " for more information."));
        return vars;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        return this.getVariables();
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        if (this.stringNotNull(this.myExceptionMessage)) {
            return this.myExceptionMessage;
        }
        return this.myInitializationFailureMessage;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return this.getName();
    }

    private boolean stringNotNull(String string) {
        return string != null && !string.equalsIgnoreCase("null") && !string.equals("");
    }
}

