/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.FeeConfiguration;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;

@Immutable
@ConfigurationClass(value=FeeConfiguration.class)
public class Fee
extends ImmutableModifier
implements TraceableV2 {
    protected final RatingDecimal myFee;
    private static final Object CURRENT_PRICE_FACTOR = new Object();
    private static final Object MONEY_LEFT = new Object();

    public static Fee create(ParseContext ctx, TariffStructureNode[] children) {
        return new Fee(ctx);
    }

    Fee(ParseContext ctx) {
        super(ctx);
        FeeConfiguration conf = FeeConfiguration.create(ctx);
        this.myFee = conf.getPrice();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myFee == null ? 0 : this.myFee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Fee other = (Fee)obj;
        return !(this.myFee == null ? other.myFee != null : !this.myFee.equals(other.myFee));
    }

    @Override
    public void perform(DataSet theData) {
        if (!(theData instanceof RatingDataSet)) {
            throw new TreeExecutionException("The passed data set does not have rating capabilities.");
        }
        RatingDataSet data = (RatingDataSet)theData;
        RatingDecimal fee = this.myFee.multiply(data.getCurrentPriceFactor());
        if (data.getMoneyLeft().subtract(fee).isMoreThanOrEqualToZero() || data.getMoneyLeft().isMinusOne()) {
            data.allocateCost(fee);
        } else {
            data.stopExecution();
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        RatingDecimal priceFactor = (RatingDecimal)tp.getInfo(CURRENT_PRICE_FACTOR);
        RatingDecimal moneyLeft = (RatingDecimal)tp.getInfo(MONEY_LEFT);
        StringBuilder traceBuilder = new StringBuilder();
        traceBuilder.append("Fee : Fee=").append(this.myFee.round(5, 6));
        traceBuilder.append(" Price factor=").append(priceFactor.round(5, 6)).append("\n");
        traceBuilder.append("      Money left=").append(moneyLeft.round(5, 6)).append("\n");
        return traceBuilder.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        RatingDecimal currentPriceFactor = ((RatingDataSet)tp.getPreDataSet()).getCurrentPriceFactor();
        tp.addInfo(CURRENT_PRICE_FACTOR, currentPriceFactor);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        RatingDecimal moneyLeft = ((RatingDataSet)tp.getPostDataSet()).getMoneyLeft();
        tp.addInfo(MONEY_LEFT, moneyLeft);
    }
}

