/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.BeanBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeeConfiguration
extends BeanBasedPluginConfiguration {
    private RatingDecimal myFee;

    public FeeConfiguration(RatingDecimal price) {
        super(null);
        this.myFee = price;
    }

    private FeeConfiguration(ParseContext context) {
        super(context);
        NodeList children = context.getXMLNode().getChildNodes();
        Element priceNode = XMLUtil.getNamedElement("Price", children);
        String nodeValue = XMLUtil.getFirstTextContent(priceNode);
        this.myFee = new RatingDecimal(nodeValue);
    }

    public RatingDecimal getPrice() {
        return this.myFee;
    }

    public void setPrice(RatingDecimal price) {
        this.myFee = price;
    }

    public static FeeConfiguration create(ParseContext ctx) {
        return new FeeConfiguration(ctx);
    }

    @Override
    public void appendXML(Node parent) {
        Element element = parent.getOwnerDocument().createElement("Price");
        element.setTextContent(this.myFee.toString());
        parent.appendChild(element);
    }
}

