/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.FeeConfiguration;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.RatingDecimalVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class FeeProfile
extends AbstractModifierProfile {
    @Override
    public List<Variable> getVariables() {
        return this.getVariables(RatingDecimal.ZERO);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        FeeConfiguration config = FeeConfiguration.create(new ParseContextAdapter(null, iterator, null));
        return this.getVariables(config.getPrice());
    }

    private List<Variable> getVariables(RatingDecimal price) {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(new RatingDecimalVariable("Price", price));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String price = VarListUtil.getValueStringForName(variables, "Price");
        RatingDecimal rdPrice = new RatingDecimal(price);
        FeeConfiguration config = new FeeConfiguration(rdPrice);
        PluginConfigurationHelper.writeXML(config, out, indentLevel, indentMarker);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, "Price");
        return name + " price = " + price;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, "Price");
        String info = "<b>" + name + "</b> (Price = " + price + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

