/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.ContextBasedValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.InvalidFieldException;
import ericsson.ere.management.Service;
import java.text.ParseException;

public class FieldDefaultDataSetValueReader
implements DataSetValueReader {
    public static final DataSetValueReader INSTANCE = new FieldDefaultDataSetValueReader();

    protected FieldDefaultDataSetValueReader() {
    }

    @Override
    public Object getValueFromDataSet(DataSet dataSet, DataSetField dataSetField, Key key) {
        Object fetchedValue = null;
        try {
            fetchedValue = this.fetchValueFromDataSet(dataSet, dataSetField, key);
        }
        catch (DataSetValueNotFoundException e) {
            Service service = dataSet.getService();
            assert (service != null);
            FieldDefinition fieldDefinition = service.getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataSet)).getFieldDefinitionByName(dataSetField.getFieldName());
            if (fieldDefinition == null) {
                throw new IllegalStateException(e);
            }
            fetchedValue = this.createValueFromFieldDefault(fieldDefinition, key, dataSet);
            if (fetchedValue == null) {
                throw e;
            }
            fetchedValue = this.convertCreatedDefaultValue(fetchedValue, fieldDefinition, dataSetField.getDataType());
        }
        return fetchedValue;
    }

    protected Object fetchValueFromDataSet(DataSet dataSet, DataSetField dataSetField, Key key) {
        return dataSetField.getValueFromDataSet(dataSet, key);
    }

    protected Object convertCreatedDefaultValue(Object sourceValue, FieldDefinition sourceField, DataType targetDataType) {
        return DefaultDataSet.convertValue(sourceValue, targetDataType);
    }

    @Override
    public Key[] getKeysFromDataSet(DataSet dataSet, FieldIndexKeyContainer container) {
        try {
            return container.getKeySet(dataSet, this);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object createValueFromFieldDefault(FieldDefinition fieldDefinition, Key key, DataSet dataSet) {
        Object defaultValue = null;
        String defaultValueString = fieldDefinition.getDefaultValue();
        DataType dataType = fieldDefinition.getTypedDataType();
        if (defaultValueString != null && dataType != null) {
            ContextBasedValueResolver resolver = dataType.createContextBasedValueResolver().withDataSet(dataSet);
            try {
                if (key != null && key.containsIndex()) {
                    int index;
                    Object[] defaultValues = resolver.parseMultiString(defaultValueString);
                    if (defaultValues.length > (index = key.getIndex())) {
                        defaultValue = defaultValues[index];
                    }
                } else {
                    defaultValue = resolver.parseString(defaultValueString);
                }
            }
            catch (ParseException pe) {
                throw new InvalidFieldException(fieldDefinition.getFieldName());
            }
        }
        return defaultValue;
    }
}

