/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.SupersededBy;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.exception.EreFieldSetOutOfBoundsException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.FieldOperation2;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.AmountFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.NumericIntegerFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.Operation;
import com.ericsson.ere.selectiontree.modifiers.operation.OperationHelper;
import com.ericsson.ere.selectiontree.util.AmountUtil;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@SupersededBy(value=FieldOperation2.class)
@Immutable
public class FieldOperation
extends ImmutableModifier
implements TraceableV2 {
    public static final String NOT_SUPPORTED = "NOT SUPPORTED";
    protected static final String TAG_OPERATION = "Operation";
    protected static final String TAG_INDEX = "Index";
    protected static final String ATTR_FIELD = "field";
    protected static final String ATTR_OPERATION = "operation";
    protected static final String ATTR_USEFIELD = "usefield";
    protected static final String ATTR_OPERANDFIELD = "operandfield";
    protected static final String ATTR_OPERANDVALUE = "operandvalue";
    protected static final String ATTR_ADDITIONALDATA = "additionaldata";
    protected static final String ATTR_ISAFFECT = "isAffect";
    private final AbstractOperation<?, ?> myOperation;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldOperation(ParseContext ctx) {
        super(ctx);
        Element configElement = (Element)ctx.getXMLNode();
        Element operationElement = XMLUtil.getFirstElementNamed(TAG_OPERATION, configElement);
        FieldDefinition affectedFieldDefinition = FieldOperation.extractAffectedFieldDefinition(operationElement, ctx.getClassRepository());
        FieldDefinition operandFieldDefinition = FieldOperation.extractOperandFieldDefinition(operationElement, ctx.getClassRepository());
        AbstractOperation<?, ?> operation = FieldOperation.createOperation(affectedFieldDefinition, operationElement);
        FieldOperation.setupOperationWithFieldToAffect(operation, affectedFieldDefinition, configElement, ctx.getClassRepository());
        String operandFieldName = operationElement.getAttribute(ATTR_OPERANDFIELD);
        if (operandFieldDefinition != null) {
            FieldOperation.setupOperationWithOperandField(operation, operandFieldDefinition, configElement, ctx.getClassRepository());
        } else if (operandFieldName.length() > 0) {
            if (!FieldOperation.isBuiltInTimeFieldToBeSetForDateOrTimeField(affectedFieldDefinition, operandFieldName)) throw new PluginCreationException("Referenced field " + operandFieldName + " does not exist.");
            FieldOperation.setupOperationWithBuiltInOperandField(operation, operandFieldName, affectedFieldDefinition.getTypedDataType());
        } else {
            this.setupOperationWithValue(operation, affectedFieldDefinition, ctx.getClassRepository(), operationElement);
        }
        FieldOperation.setupOperationWithAdditionalDataIfApplicable(operation, operationElement);
        FieldOperation.configureOperationBoundsIfApplicable(operation, affectedFieldDefinition);
        this.myOperation = this.setupOperationWithContextDependentData(operation, ctx);
        FieldOrientedPluginUtil.checkMissingFields(this, ctx.getClassRepository());
    }

    private void setupOperationWithValue(Operation<?, ?> anOperation, FieldDefinition aTargetDef, ClassRepository aRep, Element anElement) {
        String valueString = anElement.getAttribute(ATTR_OPERANDVALUE);
        ValueResolver resolver = FieldDefinitionUtil.createValueResolver(null, aTargetDef);
        anOperation.setFieldOperand(null, valueString, null, resolver);
    }

    public static FieldOperation create(ParseContext ctx, TariffStructureNode[] children) {
        return FieldOperation.create(ctx, (DataSetValueReader)null);
    }

    protected static FieldOperation create(ParseContext ctx, DataSetValueReader reader) {
        return new FieldOperation(new FieldOperationParseContext(ctx, reader));
    }

    @Deprecated
    protected Operation<?, ?> additionalOperationSetup(Operation<?, ?> operation) {
        return operation;
    }

    private AbstractOperation<?, ?> setupOperationWithContextDependentData(AbstractOperation<?, ?> operation, ParseContext ctx) {
        if (ctx instanceof FieldOperationParseContext) {
            DataSetValueReader reader = ((FieldOperationParseContext)ctx).getDataSetValueReader();
            operation.setDataSetValueReader(reader);
        }
        return operation;
    }

    private static FieldDefinition extractAffectedFieldDefinition(Element operationElement, ClassRepository repository) {
        String affectedFieldName = operationElement.getAttribute(ATTR_FIELD);
        FieldDefinition affectedFieldDefinition = repository.getFieldDefinitionByName(affectedFieldName);
        if (affectedFieldDefinition == null) {
            throw new PluginCreationException("Referenced field " + affectedFieldName + " does not exist.");
        }
        return affectedFieldDefinition;
    }

    private static FieldDefinition extractOperandFieldDefinition(Element operationElement, ClassRepository repository) {
        boolean useOperandField = Boolean.parseBoolean(operationElement.getAttribute(ATTR_USEFIELD));
        FieldDefinition opFD = null;
        if (useOperandField) {
            String operandFieldName = operationElement.getAttribute(ATTR_OPERANDFIELD);
            opFD = repository.getFieldDefinitionByName(operandFieldName);
        }
        return opFD;
    }

    private static AbstractOperation<?, ?> createOperation(FieldDefinition affectedFD, Element operationElement) {
        DataType fieldToAffectDataType = affectedFD.getTypedDataType();
        AbstractOperation operation = (AbstractOperation)OperationHelper.getOperationForDataType(fieldToAffectDataType, operationElement.getAttribute(ATTR_OPERATION));
        return operation;
    }

    private static void setupOperationWithFieldToAffect(Operation<?, ?> operation, FieldDefinition affectedFD, Element configElement, ClassRepository repository) {
        try {
            FieldIndexKeyContainer affectedFieldIndexKeyContainer = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(FieldOperation.extractAffectedFieldIndexElement(configElement), repository, (FieldHierarchyNode)affectedFD);
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(null, affectedFD);
            DataSetField field = new DataSetField(affectedFD);
            operation.setFieldToAffect(field, affectedFieldIndexKeyContainer, resolver);
        }
        catch (IllegalArgumentException iae) {
            throw new PluginCreationException(iae);
        }
    }

    private static void setupOperationWithOperandField(Operation<?, ?> operation, FieldDefinition operandFD, Element configElement, ClassRepository repository) {
        FieldIndexKeyContainer operandFieldIndexKeyContainer = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(FieldOperation.extractOperandFieldIndexElement(configElement), repository, (FieldHierarchyNode)operandFD);
        DataSetField field = new DataSetField(operandFD);
        operation.setFieldOperand(field, null, operandFieldIndexKeyContainer, operandFD.getTypedDataType());
    }

    private static void setupOperationWithBuiltInOperandField(Operation<?, ?> operation, String operandFieldName, DataType dataType) {
        DataSetField field = new DataSetField(operandFieldName, -1, false);
        operation.setFieldOperand(field, null, null, dataType);
    }

    private static void setupOperationWithAdditionalDataIfApplicable(Operation<?, ?> operation, Element operationElement) {
        String additionalData = operationElement.getAttribute(ATTR_ADDITIONALDATA);
        if (additionalData.length() > 0) {
            operation.setAdditionalData(additionalData);
        }
    }

    private static void configureOperationBoundsIfApplicable(Operation<?, ?> operation, FieldDefinition fieldDefinition) {
        if (operation instanceof NumericIntegerFieldOperation) {
            String max = FieldDefinitionHelper.getMaxValue(fieldDefinition);
            String min = FieldDefinitionHelper.getMinValue(fieldDefinition);
            ((NumericIntegerFieldOperation)((Object)operation)).setMinMax(max, min);
        } else if (operation instanceof AmountFieldOperation) {
            ((AmountFieldOperation)operation).setAllowNegativeAmount(AmountUtil.allowsNegativeAmount(fieldDefinition, true));
        }
    }

    private static Element extractOperandFieldIndexElement(Element configElement) {
        return (Element)XMLUtil.getElementWithNameAndAttribute(TAG_INDEX, ATTR_ISAFFECT, "false", (NodeList)((Object)configElement));
    }

    private static Element extractAffectedFieldIndexElement(Element configElement) {
        return (Element)XMLUtil.getElementWithNameAndAttribute(TAG_INDEX, ATTR_ISAFFECT, "true", (NodeList)((Object)configElement));
    }

    private static boolean isBuiltInTimeFieldToBeSetForDateOrTimeField(FieldDefinition fd, String operandFieldName) {
        DataType dataType = fd.getTypedDataType();
        return !(dataType != DataType.DATE && dataType != DataType.TIME || !"CurrentTime()".equals(operandFieldName) && !"StartTime()".equals(operandFieldName));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldOperation other = (FieldOperation)obj;
        return !(this.myOperation == null ? other.myOperation != null : !this.myOperation.equals(other.myOperation));
    }

    @Override
    public void perform(DataSet theData) {
        try {
            this.myOperation.perform(theData);
        }
        catch (EreFieldSetOutOfBoundsException e) {
            throw new TreeExecutionException(e);
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet pre = TraceDataSet.createPreDataSet(tp);
        TraceDataSet post = TraceDataSet.createPostDataSet(tp);
        try {
            return this.myOperation.getTraceString(pre, post);
        }
        catch (EreFieldSetOutOfBoundsException e) {
            throw new TreeExecutionException(e);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        this.myOperation.setTracePointInfo(tp);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        this.myOperation.setPreTracePointInfo(tp);
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        set.addAll(this.myOperation.getUsedFields());
        return set;
    }

    static class FieldOperationParseContext
    extends ParseContextAdapter {
        private final DataSetValueReader myDataSetReader;

        public FieldOperationParseContext(ParseContext ctx, DataSetValueReader reader) {
            super(ctx);
            this.myDataSetReader = reader;
        }

        public DataSetValueReader getDataSetValueReader() {
            return this.myDataSetReader;
        }
    }
}

