/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.LegacyAutoConditionMapProfile;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.FieldOperationProfileContract;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.BitPatternFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DateFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DateOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.Operation;
import com.ericsson.ere.selectiontree.modifiers.operation.OperationHelper;
import com.ericsson.ere.selectiontree.modifiers.operation.OperationProfileHelper;
import com.ericsson.ere.selectiontree.modifiers.operation.TimeFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.TimeOperation;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.CombinedFieldFilter;
import com.ericsson.ere.selectiontree.util.DateTimeInteroperabilityFieldFilter;
import com.ericsson.ere.selectiontree.util.FieldListBuilderWithLegacySupport;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.NonComplexFieldFilter;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BitPatternButtonVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Constrainable(contractClass=FieldOperationProfileContract.class)
@LegacyAutoConditionMapProfile
public class FieldOperationProfile
extends AbstractFieldOrientedModifierProfile {
    private static final String FIELD_ERROR_MSG = "No available fields found";
    private static final String OPERATION_ERROR_MSG = "No available operations found";
    private static final String AFFECTED_FIELD_ERROR_MSG = "Field doesn't exist in service";
    private static final String ARRAY_MAP_SUPPORT_FEATURE = "Array_Map_Support";
    private static final String DATASET_TIME_FIELD_SUPPORT_FEATURE = "DataSet_Time_field_Support";
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private static final String LBL_FIELD_ERROR = "Field";
    private static final String LBL_OPERATION_ERROR = "Operation";
    private static final String LBL_OPERATION = "Operation";
    private static final String LBL_USEFIELD = "Use field";
    private static final String LBL_OPERAND_VALUE = "Operand value";
    private static final String LBL_MODIFY_BITS = "MODIFY BITS";
    private static final String LBL_BIT_PATTERN = "Bit pattern";
    public static final String LBL_OPERAND_FIELD = "Operand field";
    public static final String LBL_OPERAND_FIELD_INDEX = "Operand field index";
    public static final String LBL_FIELD_TO_AFFECT = "Field to affect";
    public static final String LBL_FIELD_TO_AFFECT_INDEX = "Field to affect index";
    private boolean mySupportArrayMap = false;
    private boolean mySupportDataSetTimeField = false;
    private boolean mySupportDateTimeInteroperability = false;

    private static boolean isDataTypeSupported(DataType datatype) {
        boolean result;
        switch (datatype) {
            case LONG: 
            case INTEGER: 
            case SHORT: 
            case UNSIGNEDINT: 
            case UNSIGNEDINT8: 
            case UNSIGNEDINT16: 
            case UNSIGNEDINT32: 
            case UNSIGNEDSHORT: 
            case UNSIGNEDLONG: 
            case STRING: 
            case DATE: 
            case TIME: 
            case AMOUNT: 
            case BOOLEAN: 
            case RATINGDECIMAL: 
            case OBJECT: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private AvailableFieldListBuilder createFieldsBuilder() {
        return AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withFilter(new ArrayMapFeatureFieldFilter()).withFilter(new AffectedFieldFilter()).withHierarchicalFields().withConstraints(this, null).withFilter(new LeafFieldFilter());
    }

    private String[] extractOperationNames(String firstOperandField) {
        List<String> supportedOperationList = FieldOperationProfile.getSupportedOperationList(this.myClassRepository, firstOperandField);
        ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, firstOperandField).build();
        List<String> result = ConstraintService.constrainItems(this, ctx, ConstraintTargetType.OPERATION, this.myClassRepository, new ArrayList<String>(supportedOperationList));
        return result.toArray(new String[result.size()]);
    }

    private FieldListBuilderWithLegacySupport createOperandFieldsBuilder(String affectedField, String operationName) {
        FieldDefinition affectedFD = this.myClassRepository.getFieldDefinitionByName(affectedField);
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, affectedField).addContext(ConstraintContextItemType.OPERATION, operationName).build();
        return (FieldListBuilderWithLegacySupport)new FieldListBuilderWithLegacySupport(this.myClassRepository).withAdditionalFields(this.getBuiltInFieldsIfDateAndFeatureActive(affectedField, operationName)).withFilter(this.createFieldFilterForFeatureConstraining(affectedField)).withFilter(new OperationBasedOperandFieldFilter(affectedFD, operationName)).withHierarchicalFields().withFilter(new ContextFilter(affectedFD)).withConstraints(this, context).withFilter(new LeafFieldFilter());
    }

    private List<FieldDefinition> extractOperandFields(String affectedField, String operationName) {
        return this.createOperandFieldsBuilder(affectedField, operationName).buildFieldDefinitionList();
    }

    private FieldFilter createFieldFilterForFeatureConstraining(String affectedFieldName) {
        ArrayList<FieldFilter> filters = new ArrayList<FieldFilter>();
        if (!this.mySupportArrayMap) {
            filters.add(new NonComplexFieldFilter());
        }
        if (!this.mySupportDateTimeInteroperability) {
            filters.add(new DateTimeInteroperabilityFieldFilter(this.myClassRepository.getFieldDefinitionByName(affectedFieldName)));
        }
        return new CombinedFieldFilter(filters.toArray(new FieldFilter[filters.size()]));
    }

    private List<FieldHierarchyNode> getBuiltInFieldsIfDateAndFeatureActive(String destinationFieldName, String operationName) {
        ArrayList<FieldHierarchyNode> additions = new ArrayList<FieldHierarchyNode>();
        FieldDefinition destinationField = this.myClassRepository.getFieldDefinitionByName(destinationFieldName);
        if (this.mySupportDataSetTimeField && destinationField != null && (DataType.DATE == destinationField.getTypedDataType() || DataType.TIME == destinationField.getTypedDataType()) && "SET".equals(operationName)) {
            additions.add(ClassRepositoryHelper.SPECIAL_FIELD_CURRENT_TIME);
            additions.add(ClassRepositoryHelper.SPECIAL_FIELD_START_TIME);
        }
        return additions;
    }

    static List<FieldDefinition> getSupportedAffectedFieldList(ClassRepository repository) {
        return FieldOperationProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(repository), new AffectedFieldFilter());
    }

    static List<String> getSupportedOperationList(ClassRepository repository, String fieldName) {
        if (fieldName != null) {
            FieldDefinition fieldDefinition = repository.getFieldDefinitionByName(fieldName);
            DataType dataType = fieldDefinition.getTypedDataType();
            Operation<?, ?> operation = OperationHelper.getOperationForDataType(dataType, null);
            HashSet<String> operationSet = new HashSet<String>();
            for (String s : operation.getOperationNames()) {
                operationSet.add(s);
            }
            if (fieldDefinition.hasUtil("EditComponent") && OperationHelper.isBitPatternOperationSupportedForDataType(fieldDefinition.getTypedDataType())) {
                operationSet.add(LBL_MODIFY_BITS);
            }
            return new ArrayList<String>(operationSet);
        }
        List<Operation<?, ?>> operationsList = OperationHelper.getAllOperations();
        HashSet<String> operationSet = new HashSet<String>();
        for (Operation<?, ?> currentOperation : operationsList) {
            for (String operation : currentOperation.getOperationNames()) {
                operationSet.add(operation);
            }
        }
        return new ArrayList<String>(operationSet);
    }

    static List<FieldDefinition> getSupportedOperandFieldList(ClassRepository repository, String fieldToAffect, String operationName) {
        if (fieldToAffect == null) {
            return FieldOperationProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(repository), new AllOperandFieldFilter());
        }
        FieldDefinition field = repository.getFieldDefinitionByName(fieldToAffect);
        return FieldOperationProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFieldsForField(fieldToAffect, repository), new OperationBasedOperandFieldFilter(field, operationName));
    }

    @Override
    public List<Variable> getVariables() {
        String fieldToAffectName;
        ArrayList<Variable> varList = new ArrayList<Variable>(3);
        List<FieldDefinition> fieldToAffectList = this.createFieldsBuilder().buildFieldDefinitionList();
        String string = fieldToAffectName = !fieldToAffectList.isEmpty() ? fieldToAffectList.get(0).getCanonicalName() : null;
        if (fieldToAffectName == null) {
            varList.add(new NotAllowedVariable(LBL_FIELD_TO_AFFECT, FIELD_ERROR_MSG));
            return varList;
        }
        varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD_TO_AFFECT, LBL_FIELD_TO_AFFECT, fieldToAffectList, fieldToAffectName));
        this.addIndexVariable(LBL_FIELD_TO_AFFECT_INDEX, null, fieldToAffectName, null, varList, this.createIndexVariableFactory(true));
        Object[] operationNames = this.extractOperationNames(fieldToAffectName);
        if (operationNames.length <= 0) {
            varList.add(new NotAllowedVariable("Operation", OPERATION_ERROR_MSG));
            return varList;
        }
        varList.add(new DropDownVariable("Operation", (Object)operationNames[0], operationNames));
        varList.add(new BoolVariable(LBL_USEFIELD, false));
        this.createInputFieldVariable(varList, fieldToAffectName, (String)operationNames[0], null, null);
        return varList;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> varList = new ArrayList();
        if (XMLUtil.getFirstElementNamed(LBL_FIELD_ERROR, (Element)iterator) != null) {
            varList = this.getVariables();
        } else {
            FieldHierarchyNode field;
            Element operationTag = XMLUtil.getFirstElementNamed("Operation", (Element)iterator);
            String fieldName = operationTag.getAttribute("field");
            AvailableFieldListBuilder targetBuilder = this.createFieldsBuilder();
            if (!targetBuilder.filtersAllow(field = this.myClassRepository.getFieldRepository().getFieldByName(fieldName))) {
                varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD_TO_AFFECT, null, targetBuilder.buildList(), fieldName));
                varList.add(new NotAllowedVariable("Operation", AFFECTED_FIELD_ERROR_MSG));
                return varList;
            }
            varList.add(new LazyFieldDropDownVariable(LBL_FIELD_TO_AFFECT, targetBuilder, fieldName));
            Element indexElement = (Element)XMLUtil.getElementWithNameAndAttribute("Index", "isAffect", "true", (NodeList)((Object)iterator));
            this.addIndexVariable(LBL_FIELD_TO_AFFECT_INDEX, null, fieldName, indexElement, varList, this.createIndexVariableFactory(true));
            String operationName = operationTag.getAttribute("operation");
            Object[] operationNames = this.extractOperationNames(fieldName);
            if (operationNames.length <= 0) {
                varList.add(new NotAllowedVariable("Operation", OPERATION_ERROR_MSG));
                return varList;
            }
            varList.add(new DropDownVariable("Operation", (Object)operationName, operationNames));
            boolean useField = "true".equalsIgnoreCase(operationTag.getAttribute("usefield"));
            varList.add(new BoolVariable(LBL_USEFIELD, useField));
            if (useField) {
                String operandField = operationTag.getAttribute("operandfield");
                String additionalData = operationTag.getAttribute("additionaldata");
                FieldListBuilderWithLegacySupport sourceBuilder = this.createOperandFieldsBuilder(fieldName, operationName).withLegacyField(this.myClassRepository.getFieldDefinitionByName(operandField));
                if (!sourceBuilder.filtersAllow(this.myClassRepository.getFieldDefinitionByName(operandField))) {
                    List<FieldDefinition> possibleSourceFieldsList = sourceBuilder.buildFieldDefinitionList();
                    if (possibleSourceFieldsList.isEmpty()) {
                        varList.add(new NotAllowedVariable(LBL_OPERAND_FIELD, FIELD_ERROR_MSG));
                        return varList;
                    }
                    DataType datatype = this.myClassRepository.getFieldDefinitionByName(fieldName).getTypedDataType();
                    Operation<?, ?> operation = OperationHelper.getOperationForDataType(datatype, operationName);
                    operation.setFieldToAffect(new DataSetField(fieldName, 0, false), null, datatype);
                    varList.addAll(OperationProfileHelper.getVariablesForFieldOperation(operation, LBL_OPERAND_FIELD, operandField, possibleSourceFieldsList, additionalData));
                } else {
                    DataType datatype = this.myClassRepository.getFieldDefinitionByName(fieldName).getTypedDataType();
                    Operation<?, ?> operation = OperationHelper.getOperationForDataType(datatype, operationName);
                    operation.setFieldToAffect(new DataSetField(fieldName, 0, false), null, datatype);
                    if (operation instanceof DateFieldOperation) {
                        if (!operation.getOperation().equals(DateOperation.SET.name())) {
                            Object[] unitArray = ((DateFieldOperation)operation).getUnitArray();
                            String defaultUnit = ((DateFieldOperation)operation).getSelectedUnit(additionalData);
                            varList.add(new DropDownVariable(operation.getAdditionalDataLabel(), (Object)defaultUnit, unitArray));
                        }
                    } else if (operation instanceof TimeFieldOperation && !operation.getOperation().equals(TimeOperation.SET.name())) {
                        Object[] unitArray = ((TimeFieldOperation)operation).getUnitArray();
                        String defaultUnit = ((TimeFieldOperation)operation).getSelectedUnit(additionalData);
                        varList.add(new DropDownVariable(operation.getAdditionalDataLabel(), (Object)defaultUnit, unitArray));
                    }
                    varList.add(new LazyFieldDropDownVariable(LBL_OPERAND_FIELD, sourceBuilder, operandField));
                }
                String operandFieldName = VarListUtil.getVariableForName(varList, LBL_OPERAND_FIELD).getValueString();
                indexElement = (Element)XMLUtil.getElementWithNameAndAttribute("Index", "isAffect", "false", (NodeList)((Object)iterator));
                this.addIndexVariable(LBL_OPERAND_FIELD_INDEX, null, operandFieldName, indexElement, varList, this.createIndexVariableFactory(false));
            } else {
                String operandValue = operationTag.getAttribute("operandvalue");
                String additionalData = operationTag.getAttribute("additionaldata");
                this.createInputFieldVariable(varList, fieldName, operationName, additionalData, operandValue);
            }
        }
        return varList;
    }

    @Override
    public Variable createVariableForFieldList(String label, String key, List<String> fields, String defaultChoice) {
        List<FieldDefinition> fieldDefs = FieldDefinitionHelper.extractFieldDefinitionList(this.myClassRepository, fields);
        return FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(label, key, fieldDefs, defaultChoice);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        ValueFieldCompositeObject operandFieldIndexObject;
        String additionalData;
        DataType dataType;
        Operation<?, ?> theOperation;
        StringBuilder xml = new StringBuilder();
        for (Variable currentVariable : variables) {
            if (!(currentVariable instanceof NotAllowedVariable)) continue;
            out.println("<Field/>");
            return;
        }
        String fieldToAffect = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_AFFECT);
        FieldDefinition fieldToAffectFieldDef = this.myClassRepository.getFieldDefinitionByName(fieldToAffect);
        xml.append("field='" + fieldToAffect + "' ");
        String operation = VarListUtil.getValueStringForName(variables, "Operation");
        xml.append("operation='" + operation + "' ");
        if (VarListUtil.getBooleanValueForName(variables, LBL_USEFIELD) != null) {
            boolean useOperandField = VarListUtil.getBooleanValueForName(variables, LBL_USEFIELD);
            xml.append("usefield='" + useOperandField + "' ");
            if (useOperandField) {
                String operandField = VarListUtil.getValueStringForName(variables, LBL_OPERAND_FIELD);
                xml.append("operandfield='" + operandField + "' ");
            } else {
                String value = VarListUtil.getValueStringForName(variables, LBL_OPERAND_VALUE);
                xml.append("operandvalue='" + XMLUtil.escape(value) + "' ");
            }
        }
        if (operation.equals(LBL_MODIFY_BITS)) {
            String value = VarListUtil.getValueStringForName(variables, LBL_BIT_PATTERN);
            xml.append("operandvalue='" + XMLUtil.escape(value) + "' ");
        }
        if ((theOperation = OperationHelper.getOperationForDataType(dataType = fieldToAffectFieldDef.getTypedDataType(), operation)).useAdditionalData() && (additionalData = VarListUtil.getStringValueForName(variables, theOperation.getAdditionalDataLabel())) != null) {
            xml.append("additionaldata='" + additionalData + "' ");
        }
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Operation " + xml.toString() + "/>");
        ValueFieldCompositeObject affectedFieldIndexObject = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_TO_AFFECT_INDEX));
        if (affectedFieldIndexObject != null) {
            int i;
            for (i = 0; i < indentLevel + 2; ++i) {
                out.print(indentMarker);
            }
            out.println("<Index isAffect='true'>");
            out.println(affectedFieldIndexObject.getXMLRepresentation());
            for (i = 0; i < indentLevel + 2; ++i) {
                out.print(indentMarker);
            }
            out.println("</Index>");
        }
        if ((operandFieldIndexObject = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_OPERAND_FIELD_INDEX))) != null) {
            int i;
            for (i = 0; i < indentLevel + 2; ++i) {
                out.print(indentMarker);
            }
            out.println("<Index isAffect='false'>");
            out.println(operandFieldIndexObject.getXMLRepresentation());
            for (i = 0; i < indentLevel + 2; ++i) {
                out.print(indentMarker);
            }
            out.println("</Index>");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        if (!this.parameterCandidateForChange(reference)) return false;
        FieldDefinition fieldToAffect = (FieldDefinition)VarListUtil.getValueForName(vars, LBL_FIELD_TO_AFFECT);
        String operationName = VarListUtil.getVariableForName(vars, "Operation") != null ? VarListUtil.getStringValueForName(vars, "Operation") : null;
        Boolean useField = VarListUtil.getVariableForName(vars, LBL_USEFIELD) != null ? VarListUtil.getBooleanValueForName(vars, LBL_USEFIELD) : null;
        boolean hasChanged = false;
        if (LBL_FIELD_TO_AFFECT.equals(reference)) {
            FieldOperationProfile.removeVariablesAfter(value, vars);
            hasChanged = true;
            operationName = null;
            this.addIndexVariable(LBL_FIELD_TO_AFFECT_INDEX, null, fieldToAffect.getCanonicalName(), null, vars, this.createIndexVariableFactory(true));
            Object[] extractOperationNames = this.extractOperationNames(fieldToAffect.getCanonicalName());
            if (extractOperationNames.length <= 0) {
                vars.add(new NotAllowedVariable("Operation", OPERATION_ERROR_MSG));
                return true;
            }
            operationName = extractOperationNames[0];
            vars.add(new DropDownVariable("Operation", (Object)extractOperationNames[0], extractOperationNames));
        }
        if ("Operation".equals(reference) || VarListUtil.getVariableForName(vars, LBL_USEFIELD) == null) {
            if (!hasChanged) {
                FieldOperationProfile.removeVariablesAfter(value, vars);
                hasChanged = true;
            }
            if (useField == null) {
                useField = false;
            }
            vars.add(new BoolVariable(LBL_USEFIELD, useField));
        }
        if (!(LBL_USEFIELD.equals(reference) || VarListUtil.getVariableForName(vars, LBL_OPERAND_FIELD) == null && VarListUtil.getVariableForName(vars, LBL_OPERAND_VALUE) == null)) {
            if (!LBL_OPERAND_FIELD.equals(reference)) return hasChanged;
        }
        if (!hasChanged) {
            FieldOperationProfile.removeVariablesAfter(value, vars);
        }
        hasChanged = true;
        DataType dataType = fieldToAffect.getTypedDataType();
        Operation<?, ?> operation = OperationHelper.getOperationForDataType(dataType, operationName);
        operation.setFieldToAffect(new DataSetField(fieldToAffect), null, dataType);
        if (!useField.booleanValue()) {
            String additionalData = VarListUtil.getStringValueForName(vars, operation.getAdditionalDataLabel());
            this.createInputFieldVariable(vars, fieldToAffect.getCanonicalName(), operationName, additionalData, null);
            return hasChanged;
        }
        List<FieldDefinition> operandFields = this.extractOperandFields(fieldToAffect.getCanonicalName(), operationName);
        if (operandFields.isEmpty()) {
            vars.add(new NotAllowedVariable(LBL_FIELD_TO_AFFECT, FIELD_ERROR_MSG));
            return true;
        }
        if (!LBL_OPERAND_FIELD.equals(reference)) {
            String additionalData = VarListUtil.getStringValueForName(vars, operation.getAdditionalDataLabel());
            vars.addAll(OperationProfileHelper.getVariablesForFieldOperation(operation, LBL_OPERAND_FIELD, operandFields.get(0).getCanonicalName(), operandFields, additionalData));
        }
        String operandFieldName = VarListUtil.getVariableForKey(vars, LBL_OPERAND_FIELD).getValueString();
        this.addIndexVariable(LBL_OPERAND_FIELD_INDEX, null, operandFieldName, null, vars, this.createIndexVariableFactory(false));
        return hasChanged;
    }

    private boolean parameterCandidateForChange(String parameterLabel) {
        return LBL_FIELD_TO_AFFECT.equals(parameterLabel) || "Operation".equals(parameterLabel) || LBL_USEFIELD.equals(parameterLabel) || LBL_OPERAND_FIELD.equals(parameterLabel) || LBL_FIELD_TO_AFFECT_INDEX.equals(parameterLabel) || LBL_OPERAND_FIELD_INDEX.equals(parameterLabel);
    }

    private static void removeVariablesAfter(Variable value, List<Variable> varList) {
        while (varList.get(varList.size() - 1) != value) {
            varList.remove(varList.size() - 1);
        }
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, FieldOperationProfile.getSupportedFeatures());
        this.mySupportArrayMap = enabledFeatures.contains(ARRAY_MAP_SUPPORT_FEATURE);
        this.mySupportDataSetTimeField = enabledFeatures.contains(DATASET_TIME_FIELD_SUPPORT_FEATURE);
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    private void addOperationText(List<Variable> variables, StringBuilder info) {
        String fieldToAffect = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_AFFECT);
        String operation = VarListUtil.getValueStringForName(variables, "Operation");
        assert (fieldToAffect != null) : "Null check for this exists in getDescription.";
        if (operation == null) {
            this.appendInParentheses(info, "Operation");
        } else if (operation.equals(LBL_MODIFY_BITS)) {
            String fieldToAffectString = this.createDisplayableFieldDescription(fieldToAffect, (ValueFieldCompositeObject)VarListUtil.getValueForName(variables, LBL_FIELD_TO_AFFECT_INDEX));
            String operandString = VarListUtil.getValueStringForName(variables, LBL_BIT_PATTERN);
            this.appendInParentheses(info, fieldToAffectString, operation.toLowerCase(), operandString);
        } else {
            String operandString;
            AbstractOperation<?, ?> currentOperation = this.createOperationForFieldAndVariables(fieldToAffect, operation, variables);
            boolean useField = VarListUtil.getBooleanValueForName(variables, LBL_USEFIELD);
            if (useField) {
                String operandFieldString;
                String fieldName = VarListUtil.getValueStringForName(variables, LBL_OPERAND_FIELD);
                if (FieldOperationProfile.isBuiltInTimeField(fieldName)) {
                    operandFieldString = fieldName;
                } else {
                    ValueFieldCompositeObject vfco = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(VarListUtil.getVariableForKey(variables, LBL_OPERAND_FIELD_INDEX));
                    operandFieldString = this.createDisplayableFieldDescription(fieldName, vfco);
                }
                operandString = operandFieldString + currentOperation.getAdditionalInformationString();
            } else {
                operandString = this.getOperandValue(variables, currentOperation, fieldToAffect);
            }
            ValueFieldCompositeObject vfco = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_TO_AFFECT_INDEX));
            String fieldToAffectString = this.createDisplayableFieldDescription(fieldToAffect, vfco);
            this.appendInParentheses(info, fieldToAffectString, operation.toLowerCase(), operandString);
        }
    }

    private String getOperandValue(List<Variable> vars, AbstractOperation<?, ?> operation, String fieldToAffect) {
        Object valueObject = VarListUtil.getValueForName(vars, LBL_OPERAND_VALUE);
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldToAffect);
        return operation.makeDisplayableStringFromOperandValueObject(valueObject, field) + operation.getAdditionalInformationString();
    }

    private void appendInParentheses(StringBuilder builder, String ... strings) {
        builder.append(" (");
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            builder.append(strings[i]);
        }
        builder.append(')');
    }

    private String createDisplayableFieldDescription(String fieldName, ValueFieldCompositeObject vfco) {
        String text = "";
        FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(fieldName);
        if (fieldDefinition != null) {
            text = FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(fieldDefinition, vfco, this.myClassRepository);
        }
        return text;
    }

    private static boolean isBuiltInTimeField(String fieldName) {
        return "CurrentTime()".equals(fieldName) || "StartTime()".equals(fieldName);
    }

    private AbstractOperation<?, ?> createOperationForFieldAndVariables(String fieldToAffect, String operationString, List<Variable> variables) {
        FieldDefinition affectedFieldDefinition = this.myClassRepository.getFieldDefinitionByName(fieldToAffect);
        assert (affectedFieldDefinition != null) : "Null check for this exists in getDescription.";
        DataType dataType = affectedFieldDefinition.getTypedDataType();
        Operation<?, ?> operation = OperationHelper.getOperationForDataType(dataType, operationString);
        String additionalData = VarListUtil.getValueStringForName(variables, operation.getAdditionalDataLabel());
        if (additionalData != null) {
            operation.setAdditionalData(additionalData);
        }
        return (AbstractOperation)operation;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String desc = this.getDescription(variables);
        return GuiUtil.descriptionToTooltip(desc, this.getName(), this.getComment(variables));
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String fieldName;
        StringBuilder info = new StringBuilder();
        String name = super.getDescription(variables);
        if (name != null) {
            info.append(name);
        }
        if (this.myClassRepository.getFieldDefinitionByName(fieldName = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_AFFECT)) == null) {
            info.append(" (" + fieldName + ")");
        } else {
            for (Variable currentVariable : variables) {
                if (!(currentVariable instanceof NotAllowedVariable)) continue;
                String text = currentVariable.getLabel().equals(LBL_FIELD_TO_AFFECT) || currentVariable.getLabel().equals(LBL_OPERAND_FIELD) ? FIELD_ERROR_MSG : "Operation";
                this.appendInParentheses(info, text);
                return info.toString();
            }
            this.addOperationText(variables, info);
        }
        return info.toString();
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_FIELD_TO_AFFECT), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_OPERAND_FIELD), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_FIELD_TO_AFFECT_INDEX), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_OPERAND_FIELD_INDEX), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_OPERAND_VALUE), this.myClassRepository, false));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    private void createInputFieldVariable(List<Variable> vars, String firstOperandField, String selectedOperation, String additionalData, String value) {
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(firstOperandField);
        DataType dataType = fd.getTypedDataType();
        Operation<?, ?> operation = OperationHelper.getOperationForDataType(dataType, selectedOperation);
        operation.setFieldToAffect(new DataSetField(fd), null, dataType);
        boolean isSetOperation = "SET".equals(VarListUtil.getValueStringForName(vars, "Operation"));
        if (operation instanceof BitPatternFieldOperation) {
            vars.remove(vars.size() - 1);
            vars.add(new BitPatternButtonVariable(LBL_BIT_PATTERN, StringUtil.isEmptyString(value) ? "0" : value, dataType));
        } else if (fd.getTypedDataType() == DataType.AMOUNT && !isSetOperation) {
            vars.add(VariableFactory.createAmountVariableForField(LBL_OPERAND_VALUE, null, this.myClassRepository, fd, value, false));
        } else if (isSetOperation) {
            try {
                vars.add(this.createVariableForField(LBL_OPERAND_VALUE, null, fd, value, FieldDefinitionHelper.extractFieldNameList(this.extractOperandFields(firstOperandField, selectedOperation))));
            }
            catch (Exception e) {
                vars.add(new NotAllowedVariable(LBL_OPERAND_VALUE, "Could not create input variable"));
            }
        } else {
            vars.addAll(OperationProfileHelper.getVariablesForStaticOperation(operation, LBL_OPERAND_VALUE, value, additionalData, null, null));
        }
    }

    static List<String> getSupportedFeatures() {
        return Arrays.asList(ARRAY_MAP_SUPPORT_FEATURE, DATASET_TIME_FIELD_SUPPORT_FEATURE, DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = this.createMapIfNonExisting(prev);
        Element rootTag = XMLUtil.getFirstElementNamed("Operation", (Element)data);
        if (rootTag != null) {
            String fieldName = rootTag.getAttribute("field");
            displayValuesMap.put(LBL_FIELD_TO_AFFECT, fieldName);
            String operationString = rootTag.getAttribute("operation");
            displayValuesMap.put("Operation", operationString);
            String useField = rootTag.getAttribute("usefield");
            boolean shouldUseField = Boolean.parseBoolean(useField);
            displayValuesMap.put(LBL_USEFIELD, useField);
            if (shouldUseField) {
                String operandField = rootTag.getAttribute("operandfield");
                if (!"".equals(operandField)) {
                    displayValuesMap.put(LBL_OPERAND_FIELD, operandField);
                }
            } else {
                FieldDefinition fd;
                String operandValue = rootTag.getAttribute("operandvalue");
                if (!operandValue.equals("") && (fd = this.myClassRepository.getFieldDefinitionByName(fieldName)) != null) {
                    String displayValue = FieldOrientedPluginUtil.describeFieldValue(fd, operandValue);
                    displayValuesMap.put(LBL_OPERAND_VALUE, displayValue);
                }
            }
            NodeList indexElements = ((Element)data).getElementsByTagName("Index");
            if (indexElements.getLength() > 0) {
                Element secondIndexElement;
                Element firstIndexElement = (Element)indexElements.item(0);
                if (firstIndexElement != null) {
                    this.addIndexValue(displayValuesMap, firstIndexElement);
                }
                if ((secondIndexElement = (Element)indexElements.item(1)) != null) {
                    this.addIndexValue(displayValuesMap, secondIndexElement);
                }
            }
        }
        return displayValuesMap;
    }

    private void addIndexValue(Map<String, Object> displayValuesMap, Element indexElement) {
        String indexForAffectedField = indexElement.getAttribute("isAffect");
        Boolean isIndexForAffectedField = Boolean.valueOf(indexForAffectedField);
        Element valueElement = XMLUtil.getFirstElementNamed("Value", indexElement);
        if (isIndexForAffectedField.booleanValue()) {
            displayValuesMap.put(LBL_FIELD_TO_AFFECT_INDEX, valueElement.getTextContent());
        } else {
            displayValuesMap.put(LBL_OPERAND_FIELD_INDEX, valueElement.getTextContent());
        }
    }

    private Map<String, Object> createMapIfNonExisting(Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = prev;
        if (displayValuesMap == null) {
            displayValuesMap = new HashMap<String, Object>();
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValuesMap = super.getDisplayValues(variables, prev);
        String fieldName = VarListUtil.getValueStringForName(variables, LBL_FIELD_TO_AFFECT);
        String operation = VarListUtil.getValueStringForName(variables, "Operation");
        if (!operation.equals(AFFECTED_FIELD_ERROR_MSG)) {
            Boolean useField = VarListUtil.getBooleanValueForName(variables, LBL_USEFIELD);
            displayValuesMap.put(LBL_USEFIELD, useField.toString());
            if (!useField.booleanValue()) {
                AbstractOperation<?, ?> currentOperation = this.createOperationForFieldAndVariables(fieldName, operation, variables);
                String value = this.getOperandValue(variables, currentOperation, fieldName);
                displayValuesMap.put(LBL_OPERAND_VALUE, value);
            }
        }
        this.replaceFieldDefinitionWithFieldName(LBL_FIELD_TO_AFFECT, displayValuesMap, variables);
        this.replaceFieldDefinitionWithFieldName(LBL_FIELD_TO_AFFECT_INDEX, displayValuesMap, variables);
        this.replaceFieldDefinitionWithFieldName(LBL_OPERAND_FIELD, displayValuesMap, variables);
        this.replaceFieldDefinitionWithFieldName(LBL_OPERAND_FIELD_INDEX, displayValuesMap, variables);
        return displayValuesMap;
    }

    private void replaceFieldDefinitionWithFieldName(String variableLabel, Map<String, Object> map, List<Variable> varList) {
        Variable sourceVar = VarListUtil.getVariableForKey(varList, variableLabel);
        if (sourceVar != null) {
            map.put(variableLabel, sourceVar.getValueString());
        }
    }

    private IndexVariableFactory createIndexVariableFactory(boolean allowMultiInput) {
        return IndexVariableFactory.buildFactory().withMultipleInputAllowed(allowMultiInput).withFilterableFieldVariable(true).withHierarchicalFieldSupport(true).withDateTimeInteroperability(this.mySupportDateTimeInteroperability).andRepository(this.myClassRepository);
    }

    private static class LeafFieldFilter
    implements HierarchicalFieldFilter {
        private LeafFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return field.isLeaf();
        }
    }

    private static class OperationBasedOperandFieldFilter
    implements FieldFilter {
        private Operation<?, ?> myOperation;
        private FieldDefinition myField;

        private OperationBasedOperandFieldFilter(FieldDefinition field, String operationName) {
            this.myField = field;
            DataType datatype = field.getTypedDataType();
            this.myOperation = OperationHelper.getOperationForDataType(datatype, operationName);
            this.myOperation.setFieldToAffect(new DataSetField(field), null, datatype);
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented() && this.myOperation.isDataTypeSupported(field.getDataType()) && FieldDefinitionUtil.areFieldsUsingSameValueClass(this.myField, field) && !field.isSet();
        }
    }

    private static class AllOperandFieldFilter
    implements FieldFilter {
        private AllOperandFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented() && !field.isSet() && FieldOperationProfile.isDataTypeSupported(field.getTypedDataType());
        }
    }

    private static class ContextFilter
    implements FieldFilter {
        private final FieldDefinition myField;

        public ContextFilter(FieldDefinition field) {
            this.myField = field;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return this.myField.getContextNames().isEmpty() || field.getContextNames().isEmpty() || !Collections.disjoint(field.getContextNames(), this.myField.getContextNames());
        }
    }

    private class ArrayMapFeatureFieldFilter
    implements FieldFilter {
        private ArrayMapFeatureFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return FieldOperationProfile.this.mySupportArrayMap ? true : !field.isComplexType();
        }
    }

    private static class AffectedFieldFilter
    implements FieldFilter {
        private List<String> mySupportedParameterTypes = new ArrayList<String>(Arrays.asList(ClassRepository.OUTPUT_TYPES));

        private AffectedFieldFilter() {
            this.mySupportedParameterTypes.add("INTERNAL");
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return this.mySupportedParameterTypes.contains(field.getParameterType()) && !field.isSet() && FieldOperationProfile.isDataTypeSupported(field.getTypedDataType()) && !field.isKey();
        }
    }
}

