/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.SupersededBy;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.AbstractSetFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.modifiers.SetAmountFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetBcdStringFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetBooleanFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetDateFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetDecimalFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetDoubleFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetFieldModifier2;
import com.ericsson.ere.selectiontree.modifiers.SetIntegerFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetLongFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetMonetaryUnitsFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetObjectFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetOctetStringFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetRatingDecimalFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetShortFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetStringFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetTimeFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetUIntegerFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetULongFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetUShortFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetUnsignedInt16FieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetUnsignedInt32FieldModifier;
import com.ericsson.ere.selectiontree.modifiers.SetUnsignedInt8FieldModifier;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;

@SupersededBy(value=SetFieldModifier2.class)
@Immutable
public class SetFieldModifier
extends ImmutableModifier {
    public static final String TAG_TREE_DEFINED_FIELD = "TreeDefinedField";
    public static final String TAG_VALUE = "Value";
    public static final String TAG_COPYFROM = "CopyFrom";

    public SetFieldModifier() {
        super(null);
    }

    public static TariffStructureNode create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return SetFieldModifier.create(ctx, (DataSetValueReader)null);
    }

    protected static TariffStructureNode create(ParseContext ctx, DataSetValueReader reader) {
        String fieldName = SetFieldModifier.extractFieldName(ctx);
        if (fieldName != null && fieldName.equals("")) {
            return new SetFieldModifier();
        }
        DataType dataType = SetFieldModifier.extractDataType(fieldName, ctx);
        return SetFieldModifier.createSpecificModifier(new AbstractSetFieldModifier.SetFieldParseContext(ctx, reader), dataType);
    }

    private static String extractFieldName(ParseContext ctx) {
        String fieldName;
        try {
            fieldName = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(TAG_TREE_DEFINED_FIELD, ctx.getXMLNode().getChildNodes()));
        }
        catch (NullPointerException e) {
            throw new PluginCreationException(ctx.getXMLNode());
        }
        return fieldName;
    }

    private static DataType extractDataType(String fieldName, ParseContext ctx) {
        DataType dataType;
        try {
            dataType = ctx.getClassRepository().getFieldDefinitionByName(fieldName).getTypedDataType();
        }
        catch (NullPointerException e) {
            throw new PluginCreationException(e);
        }
        return dataType;
    }

    protected static TariffStructureNode createSpecificModifier(ParseContext ctx, DataType dataType) {
        switch (dataType) {
            case UNSIGNEDINT8: {
                return SetUnsignedInt8FieldModifier.create(ctx, null);
            }
            case UNSIGNEDINT16: {
                return SetUnsignedInt16FieldModifier.create(ctx, null);
            }
            case UNSIGNEDINT32: {
                return SetUnsignedInt32FieldModifier.create(ctx, null);
            }
            case MONETARYUNITS: {
                return SetMonetaryUnitsFieldModifier.create(ctx, null);
            }
            case DECIMAL: {
                return SetDecimalFieldModifier.create(ctx, null);
            }
            case STRING: {
                return SetStringFieldModifier.create(ctx, null);
            }
            case BCDSTRING: {
                return SetBcdStringFieldModifier.create(ctx, null);
            }
            case OCTETSTRING: {
                return SetOctetStringFieldModifier.create(ctx, null);
            }
            case UNSIGNEDSHORT: {
                return SetUShortFieldModifier.create(ctx, null);
            }
            case SHORT: {
                return SetShortFieldModifier.create(ctx, null);
            }
            case UNSIGNEDINT: {
                return SetUIntegerFieldModifier.create(ctx, null);
            }
            case INTEGER: {
                return SetIntegerFieldModifier.create(ctx, null);
            }
            case UNSIGNEDLONG: {
                return SetULongFieldModifier.create(ctx, null);
            }
            case LONG: {
                return SetLongFieldModifier.create(ctx, null);
            }
            case DOUBLE: {
                return SetDoubleFieldModifier.create(ctx, null);
            }
            case BOOLEAN: {
                return SetBooleanFieldModifier.create(ctx, null);
            }
            case DATE: {
                return SetDateFieldModifier.create(ctx, null);
            }
            case TIME: {
                return SetTimeFieldModifier.create(ctx, null);
            }
            case AMOUNT: {
                return SetAmountFieldModifier.create(ctx, null);
            }
            case RATINGDECIMAL: {
                return SetRatingDecimalFieldModifier.create(ctx, null);
            }
            case OBJECT: {
                return SetObjectFieldModifier.create(ctx, null);
            }
        }
        return null;
    }

    @Override
    public void perform(DataSet theData) {
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return this.myTypename + " : This modifier does not set any fields.";
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Deprecated
    protected static DataType extractDataTypeForFieldFromRepository(String fieldName, ParseContext ctx) {
        int dataTypeIdentifier = ctx.getClassRepository().getFieldDefinitionByName(fieldName).getDatatype();
        return DataType.lookup(dataTypeIdentifier);
    }

    @Deprecated
    protected static String extractFieldNameFromParseContext(ParseContext ctx) {
        return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(TAG_TREE_DEFINED_FIELD, ctx.getXMLNode().getChildNodes()));
    }
}

