/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.IdentityExpressionToken;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractMFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionVariant;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ComplexRow
extends AbstractMFORow {
    protected List<MFORow> myRows;
    private final List<IdentityExpressionToken> myLeadTokens = Arrays.asList(new IdentityExpressionToken(ExpressionToken.LEFT_PAREN));
    private final List<IdentityExpressionToken> myTailTokens = Arrays.asList(new IdentityExpressionToken(ExpressionToken.RIGHT_PAREN));

    public ComplexRow(List<? extends MFORow> rows) {
        if (rows.size() == 0) {
            throw new IllegalArgumentException("Must have at least one sub row.");
        }
        this.myRows = new ArrayList<MFORow>(rows);
        for (MFORow row : this.myRows) {
            row.setParent(this);
        }
    }

    @Override
    public List<ExpressionToken> getExpressionTokens() {
        this.checkValid();
        ArrayList<ExpressionToken> tokens = new ArrayList<ExpressionToken>();
        for (MFORow row : this.myRows) {
            tokens.addAll(row.getExpressionTokens());
        }
        return tokens;
    }

    @Override
    protected List<? extends ExpressionToken> getRowTokens() {
        throw new AssertionError((Object)"getRowTokens");
    }

    protected List<? extends ExpressionToken> getLeadTokens() {
        return this.myLeadTokens;
    }

    protected List<? extends ExpressionToken> getTailTokens() {
        return this.myTailTokens;
    }

    public String describeRow(MFORow row) {
        this.checkValid();
        assert (!(row instanceof ComplexRow));
        List<ExpressionToken> tokens = row.getExpressionTokens();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i > 0) {
                b.append(" ");
            }
            b.append(tokens.get(i).toString());
        }
        return b.toString();
    }

    public boolean canSplit() {
        return true;
    }

    public boolean canCollapseRows(MFORow row1, MFORow row2) {
        this.checkValid();
        return true;
    }

    protected void checkValid() {
        if (this.myRows == null) {
            throw new IllegalStateException("This row has been split and cannot be used.");
        }
    }

    public boolean isLeadRow(MFORow row) {
        this.checkValid();
        return this.myRows.get(0) == row;
    }

    public boolean isTailRow(MFORow row) {
        this.checkValid();
        return this.myRows.get(this.myRows.size() - 1) == row;
    }

    public List<MFORow> split() {
        this.checkValid();
        List<MFORow> rcopy = this.myRows;
        for (MFORow row : rcopy) {
            row.setParent(this.getParent());
        }
        this.myRows = null;
        return rcopy;
    }

    public void addRow(MFORow row) {
        this.addRow(this.myRows.size(), row);
    }

    public void addRow(int index, MFORow row) {
        this.checkValid();
        if (index < 0 || index > this.myRows.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        if (row == null) {
            throw new IllegalArgumentException("Null row cannot be added.");
        }
        this.myRows.add(index, row);
        row.setParent(this);
    }

    public void collapse(MFORow row1, MFORow row2) {
        this.collapseImpl(row1, row2, new RegularCollapser());
    }

    public void collapseFunction(MFORow row1, MFORow row2, FunctionVariant functionVariant, FunctionRow.MissingArgumentValueProvider provider) {
        if (functionVariant == null) {
            throw new IllegalArgumentException("Function must not be null.");
        }
        this.collapseImpl(row1, row2, new FunctionCollapser(functionVariant, provider));
    }

    protected void collapseImpl(MFORow row1, MFORow row2, Collapser collapser) {
        this.checkValid();
        int idx1 = this.validIndexOf(row1);
        int idx2 = this.validIndexOf(row2);
        if (idx1 > idx2) {
            throw new IllegalArgumentException("Wrong row order, expected row 1 to precede row 2.");
        }
        ArrayList<MFORow> sublist = new ArrayList<MFORow>(this.myRows.subList(idx1, idx2 + 1));
        MFORow newRow = collapser.create(sublist);
        int count = idx2 - idx1 + 1;
        while (count-- > 0) {
            this.myRows.remove(idx1);
        }
        this.myRows.add(idx1, newRow);
        newRow.setParent(this);
    }

    public void split(ComplexRow row) {
        this.checkValid();
        int idx = this.validIndexOf(row);
        this.myRows.remove(idx);
        this.myRows.addAll(idx, row.split());
        row.setParent(null);
        if (this.myRows.size() == 1 && this.myRows.get(0) instanceof ComplexRow) {
            this.split((ComplexRow)this.myRows.get(0));
        }
    }

    public boolean canDeleteRow(MFORow row) {
        this.checkValid();
        int idx = this.myRows.indexOf(row);
        if (idx < 0) {
            return false;
        }
        if (idx > 0) {
            return true;
        }
        boolean isWithinFunction = this.findInnerMostLeadFunctionRow(row) != null;
        return this.getOperatorOwner(row).allowsDeletionOfDescendantRow(row) ? true : isWithinFunction;
    }

    protected boolean allowsDeletionOfDescendantRow(MFORow row) {
        return true;
    }

    private ComplexRow getOperatorOwner(MFORow row) {
        ComplexRow parent = row.getParent();
        if (parent.isLeadRow(row) && parent.getParent() != null) {
            return this.getOperatorOwner(parent);
        }
        return parent;
    }

    public void deleteRow(MFORow row) {
        this.checkValid();
        if (row instanceof FunctionRow) {
            MFORow replacement = row.getRows().get(0);
            this.replace(row, replacement);
            if (this.canDeleteRow(replacement) && this.findInnerMostLeadFunctionRow(replacement) == null) {
                this.deleteRow(replacement);
            }
            return;
        }
        if (this.isLeadRow(row)) {
            ComplexRow operatorOwner = this.getOperatorOwner(row);
            FunctionRow innerMostFunctionParent = this.findInnerMostLeadFunctionRow(row);
            boolean isWithinFunction = this.findInnerMostLeadFunctionRow(row) != null;
            boolean allowsDeletion = operatorOwner.allowsDeletionOfDescendantRow(row);
            if (!allowsDeletion && !isWithinFunction) {
                throw new IllegalStateException("Cannot delete row.");
            }
            if (isWithinFunction) {
                ComplexRow parentOfFunction = innerMostFunctionParent.getParent();
                parentOfFunction.deleteRow(innerMostFunctionParent);
                return;
            }
        }
        this.deleteChildRow(row);
    }

    private FunctionRow findInnerMostLeadFunctionRow(MFORow row) {
        if (row instanceof FunctionRow) {
            return (FunctionRow)row;
        }
        ComplexRow parent = row.getParent();
        parent = parent != null && parent.isLeadRow(row) ? parent : null;
        return parent != null ? this.findInnerMostLeadFunctionRow(parent) : null;
    }

    protected void deleteChildRow(MFORow row) {
        int idx = this.validIndexOf(row);
        this.myRows.remove(idx);
        row.setParent(null);
        ComplexRow parent = this.getParent();
        if (this.myRows.size() == 0 && parent != null) {
            parent.deleteRow(this);
        }
    }

    protected int validIndexOf(MFORow row) {
        int idx = this.myRows.indexOf(row);
        if (idx < 0) {
            throw new IllegalArgumentException("Not a child row of this row.");
        }
        return idx;
    }

    @Override
    public Object clone() {
        ComplexRow clone = (ComplexRow)super.clone();
        ArrayList<MFORow> crows = new ArrayList<MFORow>();
        for (MFORow row : this.myRows) {
            MFORow crow = (MFORow)row.clone();
            crows.add(crow);
            crow.setParent(clone);
        }
        clone.myRows = crows;
        return clone;
    }

    @Override
    public List<MFORow> getRows() {
        ArrayList<MFORow> list = new ArrayList<MFORow>();
        for (MFORow row : this.myRows) {
            list.addAll(row.getRows());
        }
        return list;
    }

    public MFORow setRow(int index, MFORow replacement) {
        this.checkValid();
        if (index < 0 || index >= this.myRows.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Null row cannot be set.");
        }
        if (replacement == this.myRows.get(index)) {
            return null;
        }
        MFORow old = this.myRows.set(index, replacement);
        replacement.setParent(this);
        old.setParent(null);
        return old;
    }

    public void replace(MFORow current, MFORow replacement) {
        int index = this.validIndexOf(current);
        this.setRow(index, replacement);
    }

    public int indexOf(MFORow row) {
        return this.myRows.indexOf(row);
    }

    public String toString() {
        return this.myRows.toString();
    }

    private static class FunctionCollapser
    implements Collapser {
        private FunctionVariant myFunctionVariant;
        private FunctionRow.MissingArgumentValueProvider myProvider;

        FunctionCollapser(FunctionVariant func, FunctionRow.MissingArgumentValueProvider provider) {
            this.myFunctionVariant = func;
            this.myProvider = provider;
        }

        @Override
        public MFORow create(List<MFORow> rows) {
            return new FunctionRow(rows, this.myFunctionVariant, this.myProvider);
        }
    }

    private static class RegularCollapser
    implements Collapser {
        private RegularCollapser() {
        }

        @Override
        public MFORow create(List<MFORow> rows) {
            return new ComplexRow(rows);
        }
    }

    protected static interface Collapser {
        public MFORow create(List<MFORow> var1);
    }
}

