/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.BranchSearchUtil;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import javax.swing.tree.TreePath;

public class Branch
implements Comparable<Branch> {
    private TreePath myPathToLeafNode;
    private TariffStructureNode[] myBranchElements;
    private transient String myPathAsString;
    private Integer myScore;

    public Branch(TreePath pathToLeafNode) {
        this.checkPath(pathToLeafNode);
        this.myPathToLeafNode = pathToLeafNode;
    }

    private void checkPath(TreePath pathToLeafNode) {
        if (pathToLeafNode == null) {
            throw new IllegalArgumentException("Requires non-null path.");
        }
        Object first = pathToLeafNode.getPathComponent(0);
        if (!(first instanceof BranchTreeElement)) {
            throw new IllegalArgumentException("Requires that the path elements are of type BranchTreeElement.");
        }
        if (!(first instanceof TariffStructureNode)) {
            throw new IllegalArgumentException("Requires that the path elements are of type TariffStructureNode.");
        }
        if (((TariffStructureNode)first).getParent() != null) {
            throw new IllegalArgumentException("Requires first path part to be the structure root.");
        }
    }

    public TariffStructureNode[] getBranchElements() {
        this.ensureBranchElements();
        TariffStructureNode[] elems = new TariffStructureNode[this.myBranchElements.length];
        System.arraycopy(this.myBranchElements, 0, elems, 0, elems.length);
        return elems;
    }

    public String getPathAsString() {
        if (this.myPathAsString == null) {
            Object[] parts;
            StringBuilder b = new StringBuilder();
            for (Object part : parts = this.myPathToLeafNode.getPath()) {
                b.append("/");
                b.append(((TariffStructureNode)part).getNodeId());
            }
            this.myPathAsString = b.toString();
        }
        return this.myPathAsString;
    }

    private void ensureBranchElements() {
        this.myBranchElements = BranchSearchUtil.getPathElements(this);
    }

    @Override
    public int compareTo(Branch o) {
        int i;
        Object[] ownPath = this.myPathToLeafNode.getPath();
        Object[] otherPath = o.myPathToLeafNode.getPath();
        assert (ownPath[0] == otherPath[0]) : "Branch roots are different!";
        int minLen = Math.min(ownPath.length, otherPath.length);
        for (i = 0; i < minLen && ownPath[i] == otherPath[i]; ++i) {
        }
        if (i >= minLen) {
            return otherPath.length - ownPath.length;
        }
        DAGNode parent = (DAGNode)ownPath[i - 1];
        int ownIndex = parent.getIndexOfChild((DAGNode)ownPath[i]);
        int otherIndex = parent.getIndexOfChild((DAGNode)otherPath[i]);
        return ownIndex - otherIndex;
    }

    public TreePath getPath() {
        return this.myPathToLeafNode;
    }

    public String toString() {
        return this.getPathAsString();
    }

    public void setScore(int score) {
        if (score < 0 || score > 100) {
            throw new IllegalArgumentException("Branch points must be from 0 to 100.");
        }
        this.myScore = score;
    }

    public int getScore() {
        return this.myScore != null ? this.myScore : 0;
    }

    public boolean hasScore() {
        return this.myScore != null;
    }
}

