/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BranchList
extends AbstractList<Branch> {
    private List<Branch> myInnerList;
    private boolean myConsiderZeroScoreBranches = false;

    public BranchList(List<Branch> branches) {
        this.myInnerList = new ArrayList<Branch>(branches);
    }

    public BranchList considerZeroScoreBranchesInFiltering() {
        this.myConsiderZeroScoreBranches = true;
        return this;
    }

    public BranchList includeBy(BranchPredicate predicate) {
        ArrayList<Branch> ret = new ArrayList<Branch>();
        for (Branch b : this.myInnerList) {
            BranchPredicate.Match m = predicate.matches(b);
            if (!m.isSuccessful() || m.getScore() <= 0 && !this.myConsiderZeroScoreBranches) continue;
            b.setScore(m.getScore());
            ret.add(b);
        }
        return new BranchList(ret);
    }

    public BranchList excludeBy(BranchPredicate predicate) {
        ArrayList<Branch> ret = new ArrayList<Branch>(this.myInnerList);
        Iterator iterator = ret.iterator();
        while (iterator.hasNext()) {
            Branch b = (Branch)iterator.next();
            BranchPredicate.Match m = predicate.matches(b);
            if (!m.isSuccessful() || !this.shouldExcludeBranch(m, b)) continue;
            iterator.remove();
        }
        return new BranchList(ret);
    }

    private boolean shouldExcludeBranch(BranchPredicate.Match m, Branch b) {
        return this.myConsiderZeroScoreBranches ? b.getScore() == 0 || m.getScore() > 0 : m.getScore() > 0;
    }

    @Override
    public Branch get(int index) {
        return this.myInnerList.get(index);
    }

    @Override
    public int size() {
        return this.myInnerList.size();
    }
}

