/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.BranchSearchModel;
import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import com.ericsson.ere.selectiontree.search.filter.InvalidBranchFilterClassException;
import ericsson.ere.defs.EreClassLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

class BranchSearchModelIO {
    private static final String LOAD_SIG = "public static BranchFilter load(InputStream) throws IOException";
    private static final Class<?>[] LOAD_PARAMS = new Class[]{InputStream.class};
    private static final byte[] FILE_HEADER = new byte[]{104, 99, 114, 97, 101, 115, 104, 99, 110, 97, 114, 98};
    private static final byte[] FILE_EOF = new byte[]{-1, -2, -3, -4};

    BranchSearchModelIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BranchSearchModel loadFromFile(File f) throws IOException, ClassNotFoundException, InvalidBranchFilterClassException {
        BranchSearchModel model = new BranchSearchModel();
        try (DataInputStream is = new DataInputStream(new FileInputStream(f));){
            BranchSearchModelIO.verifyFileHeader(is);
            int fc = is.readInt();
            for (int i = 0; i < fc; ++i) {
                String className = is.readUTF();
                BranchFilter filter = BranchSearchModelIO.loadFilter(is, className);
                model.addFilter(filter);
            }
            BranchSearchModelIO.verifyFileEOFMarker(is);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void saveToFile(File f, BranchSearchModel model) throws IOException {
        Collection<BranchFilter> filters = model.getFilters();
        try (DataOutputStream os = new DataOutputStream(new FileOutputStream(f));){
            os.write(FILE_HEADER);
            os.writeInt(filters.size());
            for (BranchFilter bf : filters) {
                os.writeUTF(bf.getClass().getName());
                bf.save(os);
            }
            os.write(FILE_EOF);
        }
    }

    private static void verifyFileHeader(InputStream is) throws IOException {
        byte[] header = new byte[FILE_HEADER.length];
        is.read(header);
        if (!Arrays.equals(header, FILE_HEADER)) {
            throw new IOException("Invalid file header.");
        }
    }

    private static void verifyFileEOFMarker(InputStream is) throws IOException {
        byte[] eof = new byte[FILE_EOF.length];
        is.read(eof);
        if (!Arrays.equals(eof, FILE_EOF)) {
            throw new IOException("Invalid file EOF marker.");
        }
    }

    private static BranchFilter loadFilter(InputStream in, String className) throws ClassNotFoundException, IOException, InvalidBranchFilterClassException {
        Class<?> clazz = EreClassLoader.getClass(className);
        if (!BranchFilter.class.isAssignableFrom(clazz)) {
            throw new IOException("Non-BranchFilter class found: " + className);
        }
        try {
            return BranchSearchModelIO.createViaLoad(clazz, in);
        }
        catch (IllegalArgumentException ex) {
            throw BranchSearchModelIO.invalidFilter(clazz, "Load method must be static", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw BranchSearchModelIO.invalidFilter(clazz, "Unexpected load exception", cause);
        }
        catch (SecurityException ex) {
            throw BranchSearchModelIO.invalidFilter(clazz, "Inaccessible load method", ex);
        }
        catch (NoSuchMethodException ex) {
            throw BranchSearchModelIO.invalidFilter(clazz, "Missing load method", ex);
        }
        catch (IllegalAccessException ex) {
            throw BranchSearchModelIO.invalidFilter(clazz, "Inaccessible load method", ex);
        }
    }

    private static InvalidBranchFilterClassException invalidFilter(Class<?> clazz, String reason, Throwable cause) throws InvalidBranchFilterClassException {
        String msg = String.format("%s (for class %s). Expected load method signature is: %s.", reason, clazz.getName(), LOAD_SIG);
        throw new InvalidBranchFilterClassException(msg, cause);
    }

    private static BranchFilter createViaLoad(Class<?> filterClass, InputStream in) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method load = filterClass.getMethod("load", LOAD_PARAMS);
        Object[] args = new Object[]{in};
        BranchFilter filter = (BranchFilter)load.invoke(null, args);
        return filter;
    }
}

