/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.TariffStructureNodeExtension;
import com.ericsson.ere.selectiontree.TariffStructureNodeMetaDataExtension;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import com.ericsson.ere.selectiontree.search.ConditionEvaluator;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Node;

public class BranchTreeElementImpl
extends TariffStructureNodeMetaDataExtension<BranchTreeElement>
implements BranchTreeElement {
    private final Object IN_HANDLER = new Object();

    private BranchTreeElementImpl(Map<Object, ? extends Object> data, TariffStructureNode target) {
        super(BranchTreeElement.class, target, data);
    }

    public static TariffStructureNode createBranchTreeElement(TariffStructureNode element, Node config) {
        Map<Object, Node> data = Collections.singletonMap(BranchTreeElement.CONFIG_NODE_KEY, config);
        BranchTreeElementImpl handler = new BranchTreeElementImpl(data, element);
        return TariffStructureNodeExtension.createExtension(element, handler, BranchTreeElement.class);
    }

    @Override
    protected Object invokeImpl(Object proxy, Method method, Object[] args) throws Throwable {
        ConditionEvaluator evaluator;
        if (this.isConditionTest(method, args) && (evaluator = BranchTreeElementImpl.getConditionEvaluator((TariffStructureNode)proxy)) != null) {
            return this.testWithConditionEvaluator(evaluator, proxy, args);
        }
        return super.invokeImpl(proxy, method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testWithConditionEvaluator(ConditionEvaluator evaluator, Object proxy, Object[] args) {
        DataSet ds = (DataSet)args[0];
        Object object = proxy;
        synchronized (object) {
            boolean bl;
            if (this.hasElementData(this.IN_HANDLER)) {
                return ((Conditionality)((Object)this.getTarget())).test(ds);
            }
            try {
                this.setElementData(this.IN_HANDLER, Boolean.TRUE);
                bl = evaluator.test((TariffStructureNode)proxy, ds);
            }
            catch (Throwable throwable) {
                this.setElementData(this.IN_HANDLER, null);
                throw throwable;
            }
            this.setElementData(this.IN_HANDLER, null);
            return bl;
        }
    }

    private boolean isConditionTest(Method method, Object[] args) {
        return method.getDeclaringClass() == Conditionality.class && method.getName().equals("test") && args != null && args.length == 1 && DataSet.class.isInstance(args[0]);
    }

    private static ConditionEvaluator getConditionEvaluator(TariffStructureNode elem) {
        if (elem == null || !SelectionTreeUtil.isCondition(elem)) {
            return null;
        }
        ConditionEvaluator evaluator = SelectionTreeUtil.getElementData(elem, ConditionEvaluator.class);
        return evaluator;
    }

    @Override
    public TariffStructureNode getElement() {
        return this.getTarget();
    }
}

