/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.dataset;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.DataSetAccessLog;
import com.ericsson.ere.selectiontree.search.dataset.DataSetHelper;
import com.ericsson.ere.selectiontree.search.dataset.DefaultParameterIdentifier;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.management.Service;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;

public class AccessTrackingDataSetImpl
implements AccessTrackingDataSet,
MethodInterceptor,
InvocationHandler {
    private static final Class<?>[] NEW_DATASET_PARAMTYPES = new Class[]{Service.class};
    private DataSet myDataSet;
    private DataSetAccessLog myAccessLog;
    private ParameterIdentifier myParameterIdentifier;

    private AccessTrackingDataSetImpl(DataSet ds, DataSetAccessLog log, ParameterIdentifier parameterIdentifier) {
        this.myDataSet = ds;
        this.myAccessLog = log != null ? new DataSetAccessLog(log) : new DataSetAccessLog();
        this.myParameterIdentifier = parameterIdentifier;
    }

    public static DataSet createAccessTrackingDataSet(DataSet ds) {
        return AccessTrackingDataSetImpl.createAccessTrackingDataSet(ds, new DefaultParameterIdentifier());
    }

    public static DataSet createAccessTrackingDataSet(DataSet ds, ParameterIdentifier parameterIdentifier) {
        Class<?> clazz = ds.getClass();
        if (Modifier.isFinal(clazz.getModifiers())) {
            return AccessTrackingDataSetImpl.createDynamicProxy(ds, new AccessTrackingDataSetImpl(ds, null, parameterIdentifier));
        }
        return AccessTrackingDataSetImpl.createEnhancedSubClass(ds, parameterIdentifier);
    }

    private static DataSet createDynamicProxy(DataSet ds, InvocationHandler handler) {
        HashSet interfaces = new HashSet();
        interfaces.add(DataSet.class);
        if (ds instanceof RatingDataSet) {
            interfaces.add(RatingDataSet.class);
        }
        interfaces.add(AccessTrackingDataSet.class);
        for (Class<?> iface : ds.getClass().getInterfaces()) {
            interfaces.add(iface);
        }
        Object proxy = Proxy.newProxyInstance(EreClassLoader.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), handler);
        return (DataSet)proxy;
    }

    private static DataSet createEnhancedSubClass(DataSet ds, ParameterIdentifier parameterIdentifier) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(EreClassLoader.getClassLoader());
        enhancer.setSuperclass(ds.getClass());
        enhancer.setNamingPolicy(new CustomNamingPolicy());
        enhancer.setInterfaces(new Class[]{AccessTrackingDataSet.class});
        enhancer.setCallbacks(AccessTrackingDataSetImpl.callback(ds, null, parameterIdentifier));
        enhancer.setCallbackFilter(new CustomCallbackFilter());
        return AccessTrackingDataSetImpl.createDataSet(enhancer, ds, true);
    }

    private static DataSet createDataSet(Enhancer enhancer, DataSet ds, boolean withService) {
        DataSet ret;
        try {
            ret = withService ? (DataSet)enhancer.create(NEW_DATASET_PARAMTYPES, AccessTrackingDataSetImpl.serviceOf(ds)) : (DataSet)enhancer.create();
        }
        catch (CodeGenerationException ex) {
            Throwable cause = ex.getCause();
            if (withService && cause instanceof NoSuchMethodException) {
                ret = AccessTrackingDataSetImpl.createDataSet(enhancer, ds, false);
            }
            throw new IllegalArgumentException("Failed to create data set proxy.", cause);
        }
        return ret;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.intercept(proxy, method, args, null);
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result;
        if (this.isCloneRequest(method, args)) {
            return this.makeClone(obj);
        }
        if (method.getDeclaringClass() == AccessTrackingDataSet.class) {
            return this.invokeMethodOnTarget(method, proxy, this, args);
        }
        try {
            result = this.invokeMethodOnTarget(method, proxy, this.myDataSet, args);
            this.logAccess(method, args, result, null);
        }
        catch (InvocationTargetException e) {
            Throwable real = e.getTargetException();
            this.handleException(real);
            throw real;
        }
        catch (Throwable t) {
            this.handleException(t);
            throw t;
        }
        return result;
    }

    private void handleException(Throwable t) {
        this.myAccessLog.add(new DataSetAccessLog.ParameterAccess(null, null, t));
    }

    private static boolean isFinalizeMethod(Method method) {
        return "finalize".equals(method.getName()) && Modifier.isProtected(method.getModifiers()) && method.getParameterTypes().length == 0;
    }

    private static boolean isSetupTreeExecutorMethod(Method method) {
        return "setupTreeExecutor".equals(method.getName()) && Modifier.isProtected(method.getModifiers()) && method.getParameterTypes().length == 0;
    }

    private Object invokeMethodOnTarget(Method method, MethodProxy proxy, Object target, Object[] args) throws Throwable {
        return proxy != null ? proxy.invoke(target, args) : method.invoke(target, args);
    }

    private Object makeClone(Object obj) {
        Object proxy;
        DataSet clone = DataSetHelper.cloneDataSet(this.myDataSet);
        if (obj instanceof Factory) {
            Factory f = (Factory)obj;
            try {
                proxy = f.newInstance(NEW_DATASET_PARAMTYPES, AccessTrackingDataSetImpl.serviceOf(this.myDataSet), AccessTrackingDataSetImpl.callback(clone, this.myAccessLog, this.myParameterIdentifier));
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().equals("Constructor not found")) {
                    proxy = f.newInstance(AccessTrackingDataSetImpl.callback(clone, this.myAccessLog, this.myParameterIdentifier));
                }
                throw e;
            }
        } else {
            proxy = AccessTrackingDataSetImpl.createDynamicProxy(clone, new AccessTrackingDataSetImpl(clone, this.myAccessLog, this.myParameterIdentifier));
        }
        return proxy;
    }

    private static Object[] serviceOf(DataSet ds) {
        return new Object[]{ds.getService()};
    }

    private static Callback[] callback(DataSet ds, DataSetAccessLog log, ParameterIdentifier parameterIdentifier) {
        return new Callback[]{new AccessTrackingDataSetImpl(ds, log, parameterIdentifier), NoOp.INSTANCE};
    }

    private boolean isCloneRequest(Method method, Object[] args) {
        return method.getName().equals("clone") && AccessTrackingDataSetImpl.argsLength(args) == 0;
    }

    private void logAccess(Method method, Object[] args, Object result, Throwable error) {
        if (this.isVoid(method)) {
            return;
        }
        ParameterIdentifier.ParameterInfo info = this.myParameterIdentifier.identifyParameter(method, args, result, this.myDataSet);
        if (info != null && info.isUsable()) {
            this.myAccessLog.add(new DataSetAccessLog.ParameterAccess(info.identity, info.key, error));
        }
    }

    static int argsLength(Object[] args) {
        return args == null ? 0 : args.length;
    }

    private boolean isVoid(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    @Override
    public DataSetAccessLog getAccessLog() {
        return this.myAccessLog;
    }

    @Override
    public DataSet getDataSet() {
        return this.myDataSet;
    }

    public static interface ParameterIdentifier {
        public ParameterInfo identifyParameter(Method var1, Object[] var2, Object var3, DataSet var4);

        public static class ParameterInfo {
            public final Object identity;
            public final Key key;

            public ParameterInfo(Object identity, Key key) {
                this.identity = identity;
                this.key = key;
            }

            boolean isUsable() {
                return this.identity != null;
            }
        }
    }

    private static class CustomCallbackFilter
    implements CallbackFilter {
        private CustomCallbackFilter() {
        }

        @Override
        public int accept(Method method) {
            int index = 0;
            if (AccessTrackingDataSetImpl.isFinalizeMethod(method) || AccessTrackingDataSetImpl.isSetupTreeExecutorMethod(method)) {
                index = 1;
            }
            return index;
        }
    }

    private static class CustomNamingPolicy
    extends DefaultNamingPolicy {
        private CustomNamingPolicy() {
        }

        @Override
        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return super.getClassName("ERE.$EPROXY." + prefix, source, key, names);
        }

        @Override
        public String getTag() {
            return "ByERE";
        }
    }
}

