/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfexport;

import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import com.ericsson.ere.selectiontree.tdfexport.TDFExportStateFactory;
import com.ericsson.ere.selectiontree.tdfexport.states.TDFExportWizardFieldsState;
import com.ericsson.ere.selectiontree.tdfexport.states.TDFExportWizardFileState;
import com.ericsson.ere.selectiontree.tdfexport.states.TDFExportWizardProgressState;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TDFExportWizardModel
extends AbstractWizardModel {
    private File myTargetFile;
    private List<String> myTDFsToExport;
    private Map<String, TreeDefinedField> myAvailableTDFs;
    private TreeSet<String> myAvailableTDFNames;
    private TDFExportStateFactory myStateFactory;

    public TDFExportWizardModel(Map<String, TreeDefinedField> allTDFs, TDFExportStateFactory factory) {
        if (allTDFs.size() == 0) {
            throw new IllegalArgumentException("There are no available ");
        }
        this.myAvailableTDFs = allTDFs;
        this.myAvailableTDFNames = new TreeSet<String>(allTDFs.keySet());
        this.myStateFactory = factory;
        this.setUpButtonStates();
        this.setUpModelStates();
    }

    private final void setUpButtonStates() {
        this.setBackAndNextEnabled(false, false);
    }

    private void setUpModelStates() {
        TDFExportWizardFileState fileState = this.myStateFactory.createFileState(this);
        TDFExportWizardFieldsState nodesState = this.myStateFactory.createFieldsState(this);
        TDFExportWizardProgressState progressState = this.myStateFactory.createProgressState(this);
        fileState.setAdjacentStates(null, nodesState);
        nodesState.setAdjacentStates(fileState, progressState);
        progressState.setAdjacentStates(nodesState, null);
        this.setCurrentState(fileState);
    }

    @Override
    public void wizardDataChanged() {
    }

    public TreeDefinedField getTreeDefinedField(String name) {
        return this.myAvailableTDFs.get(name);
    }

    public void setTargetFile(File file) {
        this.myTargetFile = file;
    }

    public File getTargetFile() {
        return this.myTargetFile;
    }

    public List<String> getTDFsToExport() {
        return this.myTDFsToExport;
    }

    public Set<String> getAllExportableTDFs() {
        return this.myAvailableTDFNames;
    }

    public void setTDFsToExport(List<String> selected) {
        this.myTDFsToExport = selected;
    }

    @Override
    public void cancelAllActions() {
    }
}

