/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfexport.states;

import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.selectiontree.tdfexport.TDFExportWizardModel;
import com.ericsson.ere.selectiontree.tdfexport.panels.TDFExportProgressPanel;
import com.ericsson.ere.selectiontree.tdfexport.panels.TDFExportProgressView;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.swing.SwingWorker;

public class TDFExportWizardProgressState
extends AbstractWizardState {
    private TDFExportWizardModel myModel;
    private TDFExportProgressView myView;
    private SwingWorker<Void, Void> myExportWorker;
    private boolean myExportSuccess;

    public TDFExportWizardProgressState(TDFExportWizardModel model) {
        super(model);
        this.myModel = model;
        this.myView = this.createView();
    }

    protected TDFExportProgressView createView() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TDFExportWizardProgressState.this.myView = new TDFExportProgressPanel();
            }
        });
        return this.myView;
    }

    @Override
    public void activate() {
        this.myModel.setStandardStartNavigationButtonMode();
        this.doExport();
    }

    private void doExport() {
        final SynchronizedEDTProgressVisualizer visualizer = new SynchronizedEDTProgressVisualizer(this.myView);
        ProgressIndicatorHandler progressHandler = new ProgressIndicatorHandler(visualizer);
        final ProgressIndicator progressIndicator = progressHandler.getProgressIndicator();
        this.myView.setInfoText("Export started...");
        this.myExportWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                PrintWriter writer = null;
                try {
                    writer = new PrintWriter(TDFExportWizardProgressState.this.myModel.getTargetFile(), "UTF-8");
                }
                catch (FileNotFoundException e) {
                    TDFExportWizardProgressState.this.myExportSuccess = false;
                    TDFExportWizardProgressState.this.myView.handleError(e, "File Error!");
                }
                catch (UnsupportedEncodingException e) {
                    TDFExportWizardProgressState.this.myExportSuccess = false;
                    TDFExportWizardProgressState.this.myView.handleError(e, "Encoding Error!");
                }
                if (writer != null) {
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
                    writer.println("<!DOCTYPE Fields SYSTEM \"./tdf-import.dtd\">");
                    writer.flush();
                    writer.println("<Fields>");
                    List<String> tdfNames = TDFExportWizardProgressState.this.myModel.getTDFsToExport();
                    visualizer.setProgressGoal(tdfNames.size());
                    progressIndicator.progressStart();
                    for (int i = 0; i < tdfNames.size(); ++i) {
                        String tdfName = tdfNames.get(i);
                        TreeDefinedField field = TDFExportWizardProgressState.this.myModel.getTreeDefinedField(tdfName);
                        writer.println(field.getXML());
                        writer.flush();
                        progressIndicator.progressIncrement();
                        TDFExportWizardProgressState.this.myView.setInfoText("Exported TDF '" + tdfName + "' (" + (i + 1) + " of " + tdfNames.size() + ")...");
                    }
                    writer.println("</Fields>");
                    writer.flush();
                    writer.close();
                    TDFExportWizardProgressState.this.myExportSuccess = true;
                }
                return null;
            }

            @Override
            protected void done() {
                visualizer.setValue(100);
                if (TDFExportWizardProgressState.this.myExportSuccess) {
                    TDFExportWizardProgressState.this.myView.setInfoText("Export done.");
                    TDFExportWizardProgressState.this.myModel.setFinishedNavigationButtonMode();
                } else {
                    TDFExportWizardProgressState.this.myView.setInfoText("Export failed.");
                    TDFExportWizardProgressState.this.myModel.setStandardStartNavigationButtonMode();
                }
                progressIndicator.progressFinished();
            }
        };
        this.myExportWorker.execute();
    }

    @Override
    public WizardStateView getPanel() {
        return this.myView;
    }
}

