/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.tdfimport;

import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import com.ericsson.ere.io.IOCloser;
import com.ericsson.ere.io.IOUtil;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportStateFactory;
import com.ericsson.ere.selectiontree.tdfimport.states.TDFImportWizardFieldsState;
import com.ericsson.ere.selectiontree.tdfimport.states.TDFImportWizardFileState;
import com.ericsson.ere.selectiontree.tdfimport.states.TDFImportWizardProgressState;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.xml.EreXmlException;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TDFImportWizardModel
extends AbstractWizardModel {
    private File myFile;
    private List<String> myTDFNames;
    private List<String> myExistingTDFsInTheTree;
    private List<String> myExistingTDFsUsedInTree;
    private Element myRootElement;
    private List<String> myTDFsToImport;
    private ClassRepository myRepository;
    private Map<String, Element> myResultingTDFs;
    private TDFImportStateFactory myStateFactory;
    protected static final String DTD;
    private static final String ENCODING = "Encoding";
    private static final String STANDALONE = "Standalone";

    public TDFImportWizardModel(List<String> existingTdfs, List<String> tdfsInUse, ClassRepository repository, Map<String, Element> resultingTDFs, TDFImportStateFactory factory) {
        this.myExistingTDFsInTheTree = existingTdfs;
        this.myExistingTDFsUsedInTree = tdfsInUse;
        this.myRepository = repository;
        this.myResultingTDFs = resultingTDFs;
        this.myStateFactory = factory;
        this.removeDuplicates();
        this.setUpButtonStates();
        this.setUpModelStates();
    }

    private final void setUpButtonStates() {
        this.setBackAndNextEnabled(false, false);
    }

    private void removeDuplicates() {
        for (String tdfName : this.myExistingTDFsUsedInTree) {
            this.myExistingTDFsInTheTree.contains(tdfName);
            this.myExistingTDFsInTheTree.remove(tdfName);
        }
    }

    public void addTDFToResultList(String name, Element xml) {
        if (this.myRepository.getFieldDefinitionByName(name) != null) {
            this.myRepository.removeTreeDefinedField(name);
        }
        this.myRepository.addField(xml);
        this.myResultingTDFs.put(name, xml);
    }

    private void setUpModelStates() {
        TDFImportWizardFileState fileState = this.myStateFactory.createFileState(this);
        TDFImportWizardFieldsState nodesState = this.myStateFactory.createFieldsState(this);
        TDFImportWizardProgressState progressState = this.myStateFactory.createProgressState(this);
        fileState.setAdjacentStates(null, nodesState);
        nodesState.setAdjacentStates(fileState, progressState);
        progressState.setAdjacentStates(nodesState, null);
        this.setCurrentState(fileState);
    }

    public Document validateFile() throws FileNotFoundException {
        if (this.myFile == null || !this.myFile.exists()) {
            throw new FileNotFoundException("No file selected or file could not be found.");
        }
        Document tdfDocument = null;
        try {
            tdfDocument = this.handleLegacyDocumentFormat();
            if (tdfDocument == null) {
                InputSource source = new InputSource(TDFImportWizardModel.class.getResourceAsStream("tdf-import.dtd"));
                tdfDocument = XMLUtil.buildDocumentWithProvidedDTD(this.myFile, source, "tdf-import.dtd");
            }
        }
        catch (Exception e) {
            String message = "";
            if (e instanceof SAXParseException) {
                message = message + "Unable to parse import file XML.\n";
            } else if (e instanceof SAXException) {
                message = message + "Unable to validate the import file XML.\n";
            }
            String exceptionDescr = e.toString();
            message = message + exceptionDescr.substring(exceptionDescr.lastIndexOf("on:") + 3, exceptionDescr.length());
            throw new EreXmlException(message);
        }
        return tdfDocument;
    }

    private Document handleLegacyDocumentFormat() throws Exception {
        Document tdfDocument = null;
        Map<String, String> standaloneAndEncoding = this.getStandaloneAndEncodingValues(this.myFile);
        String standalone = standaloneAndEncoding.get(STANDALONE);
        String encoding = standaloneAndEncoding.get(ENCODING);
        if (standalone.equalsIgnoreCase("true")) {
            BufferedReader input;
            block8: {
                StringBuilder xml = new StringBuilder();
                input = null;
                try {
                    InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(this.myFile), encoding);
                    input = new BufferedReader(streamReader);
                    boolean foundFieldsTag = false;
                    boolean foundProcessInstruction = false;
                    String line = null;
                    while ((line = input.readLine()) != null) {
                        line = line.trim();
                        if (!foundProcessInstruction && line.matches("\\<\\?xml.*")) {
                            foundProcessInstruction = true;
                            xml.append(line + "\n");
                            xml.append("<!DOCTYPE Fields [");
                            xml.append(DTD);
                            xml.append("]>\n");
                            continue;
                        }
                        if (foundFieldsTag && line.length() > 0) {
                            xml.append(line);
                            continue;
                        }
                        if (!line.contains("<Fields>")) continue;
                        foundFieldsTag = true;
                        xml.append(line);
                    }
                    if (xml.length() <= 0) break block8;
                    tdfDocument = XMLUtil.buildDocumentFromStringAndValidate(xml.toString());
                }
                catch (Exception ex) {
                    try {
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        IOCloser.closeIgnoringException(input);
                        throw throwable;
                    }
                }
            }
            IOCloser.closeIgnoringException(input);
        }
        return tdfDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getStandaloneAndEncodingValues(File file) throws IOException {
        HashMap<String, String> values = new HashMap<String, String>();
        Boolean hasFaultyStandaloneValue = false;
        String encodingValue = "UTF-8";
        Pattern standalonePattern = Pattern.compile(".*\\sstandalone\\s*=\\s*(\"|')yes\\1.*", 32);
        Pattern encodingPattern = Pattern.compile("\\s+encoding\\s*=\\s*(\"|')(.*?)\\1", 32);
        BufferedReader inputReader = null;
        try {
            InputStreamReader streamReader = new InputStreamReader((InputStream)new FileInputStream(file), "ASCII");
            inputReader = new BufferedReader(streamReader);
            String line = null;
            while ((line = inputReader.readLine()) != null) {
                if (!line.matches("\\<\\?xml.*")) continue;
                Matcher m = encodingPattern.matcher(line);
                if (m.find()) {
                    encodingValue = m.group(2);
                }
                hasFaultyStandaloneValue = standalonePattern.matcher(line).matches();
            }
        }
        catch (Throwable throwable) {
            IOCloser.closeIgnoringException(inputReader);
            throw throwable;
        }
        IOCloser.closeIgnoringException(inputReader);
        values.put(ENCODING, encodingValue);
        values.put(STANDALONE, hasFaultyStandaloneValue.toString());
        return values;
    }

    public void createImportListFromDocument(Document doc) {
        this.myRootElement = doc.getDocumentElement();
        NodeList nl = this.myRootElement.getElementsByTagName("Field");
        ArrayList<String> names = new ArrayList<String>();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                NamedNodeMap attrs = nl.item(i).getAttributes();
                names.add(attrs.getNamedItem("Name").getNodeValue());
            }
        }
        this.myTDFNames = names;
    }

    public List<String> getTDFNames() {
        return this.myTDFNames;
    }

    public void setSelectedFile(File file) {
        this.myFile = file;
    }

    public File getSelectedFile() {
        return this.myFile;
    }

    public void clearResultingTDFs() {
        for (String name : this.myResultingTDFs.keySet()) {
            this.myRepository.removeTreeDefinedField(name);
        }
        this.myResultingTDFs.clear();
    }

    @Override
    public void wizardDataChanged() {
    }

    public boolean isUsedInTree(String tdfName) {
        return this.myExistingTDFsUsedInTree.contains(tdfName);
    }

    public boolean existsInTree(String tdfName) {
        return this.myExistingTDFsInTheTree.contains(tdfName);
    }

    public Element getTDFElementRoot() {
        return this.myRootElement;
    }

    public void setSelectedTDFList(List<String> selected) {
        this.myTDFsToImport = selected;
    }

    public List<String> getSelectedTDFList() {
        return this.myTDFsToImport;
    }

    @Override
    public void cancelAllActions() {
    }

    public boolean fieldExistsInService(String aName) {
        FieldDefinition def = this.myRepository.getFieldDefinitionByName(aName);
        return def != null && !"INTERNAL".equals(def.getParameterType());
    }

    static {
        InputStream is = TDFImportWizardModel.class.getResourceAsStream("tdf-import.dtd");
        try {
            DTD = IOUtil.readAllAndClose(new InputStreamReader(is));
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

