/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;

public class DescriptionUtils {
    public static String format(String format, String[] varNames, VariableFormattable[] formatters, List<Variable> variables) {
        Formatter formatter = new Formatter();
        VF vf = new VF(format, varNames, formatters, variables);
        vf.formatTo(formatter, 0, 0, 0);
        return formatter.toString();
    }

    public static VariableFormattable newFormat(String format, String[] varNames, VariableFormattable[] formatters, List<Variable> variables) {
        return new VF(format, varNames, formatters, variables);
    }

    public static class VFConst
    implements VariableFormattable {
        protected Variable variable;

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
        }

        @Override
        public void setVariable(Variable variable) {
            this.variable = variable;
        }
    }

    public static class VFCond
    implements VariableFormattable {
        protected Variable variable;
        protected VariableFormattable trueFormattable;
        protected VariableFormattable falseFormattable;

        public VFCond(VariableFormattable trueFormattable, VariableFormattable falseFormattable) {
            this.trueFormattable = trueFormattable;
            this.falseFormattable = falseFormattable;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            if (this.evaluate() && this.trueFormattable != null) {
                this.trueFormattable.setVariable(this.variable);
                this.trueFormattable.formatTo(formatter, flags, width, precision);
            } else if (this.falseFormattable != null) {
                this.falseFormattable.setVariable(this.variable);
                this.falseFormattable.formatTo(formatter, flags, width, precision);
            }
        }

        public boolean evaluate() {
            return this.variable != null;
        }

        @Override
        public void setVariable(Variable variable) {
            this.variable = variable;
        }
    }

    public static class VF
    implements VariableFormattable {
        String format;
        String[] varNames;
        VariableFormattable[] formatters;
        List<Variable> variables;

        public VF(String format, String[] varNames, VariableFormattable[] formatters, List<Variable> variables) {
            this.format = format;
            this.varNames = varNames;
            this.formatters = formatters;
            this.variables = variables;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            ArrayList<Object> vars = new ArrayList<Object>();
            for (int i = 0; i < this.varNames.length; ++i) {
                Variable variable = VarListUtil.getVariableForName(this.variables, this.varNames[i]);
                if (this.formatters != null && this.formatters[i] != null) {
                    this.formatters[i].setVariable(variable);
                    vars.add(this.formatters[i]);
                    continue;
                }
                if (variable == null) continue;
                Object valueObject = null;
                valueObject = variable instanceof DropDownVariable ? ((DropDownVariable)variable).getSelectedItem() : variable.getValueObject();
                if (valueObject == null) {
                    valueObject = "";
                }
                vars.add(valueObject);
            }
            formatter.format(this.format, vars.toArray());
        }

        @Override
        public void setVariable(Variable variable) {
        }
    }

    public static interface VariableFormattable
    extends Formattable {
        public void setVariable(Variable var1);
    }
}

