/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.util.StringUtil;
import java.util.List;

public final class FieldIndexFormatter {
    private final String myFieldName;
    private final FieldDefinition myField;
    private final FieldStructure myFieldStructure;
    private String mySeparator = ", ";
    private boolean myIncludeIndexFieldValue = true;
    private boolean myIncludeIndexFieldName = true;
    private boolean myUseDataSetResolution = true;
    private boolean myExcludeMainField = false;
    private DataDescriber myDataDescriber = new DefaultDataDescriber();

    public FieldIndexFormatter(FieldHierarchyNode mainField) {
        this.myFieldName = mainField.getCanonicalName();
        if (mainField.isLeaf()) {
            this.myField = (FieldDefinition)mainField;
            this.myFieldStructure = null;
        } else {
            this.myField = null;
            this.myFieldStructure = (FieldStructure)mainField;
        }
    }

    public FieldIndexFormatter(String mainFieldName) {
        this.myFieldName = mainFieldName;
        this.myField = null;
        this.myFieldStructure = null;
    }

    public FieldIndexFormatter(FieldDefinition mainField) {
        this.myField = mainField;
        this.myFieldName = mainField.getCanonicalName();
        this.myFieldStructure = null;
    }

    public void setSeparator(String separator) {
        this.mySeparator = separator;
    }

    public void setIncludeIndexFieldValue(boolean include) {
        this.myIncludeIndexFieldValue = include;
    }

    public void setExcludeMainFieldName(boolean exclude) {
        this.myExcludeMainField = exclude;
    }

    public void setDataDescriber(DataDescriber describer) {
        if (describer == null) {
            throw new IllegalArgumentException("Null describer not permitted.");
        }
        this.myDataDescriber = describer;
    }

    public void setIncludeIndexFieldName(boolean include) {
        this.myIncludeIndexFieldName = include;
    }

    public void setUseDataSetResolution(boolean enabled) {
        this.myUseDataSetResolution = enabled;
    }

    public String format(Key key, String keyFieldName, DataSet theData) {
        String ret = this.getMainFieldNameForFormattedString();
        if (key != null) {
            FieldIndexKeyContainer.KeyType keyType = key.containsIndex() ? FieldIndexKeyContainer.KeyType.VALUE_LIST : FieldIndexKeyContainer.KeyType.VALUE_MAP;
            Object[] objects = this.extractValuesFromKeys(new Key[]{key});
            KeyValue[] kvs = new KeyValue[objects.length];
            String fn = objects.length > 1 ? null : keyFieldName;
            for (int i = 0; i < objects.length; ++i) {
                kvs[i] = new KeyValue(fn, objects[i]);
            }
            ret = this.formatFieldAndIndexSpec(this.extractRepository(theData), keyType, kvs);
        }
        return ret;
    }

    public String format(FieldIndexKeyContainer keyContainer, DataSet theData) {
        String ret = this.getMainFieldNameForFormattedString();
        if (keyContainer != null) {
            KeyValue[] keyValues = this.extractKeyValues(keyContainer, theData);
            ret = this.formatFieldAndIndexSpec(this.extractRepository(theData), keyContainer.getKeyType(), keyValues);
        }
        return ret;
    }

    public String format(ClassRepository repository, ValueFieldCompositeObject vfco) {
        String ret = this.getMainFieldNameForFormattedString();
        if (vfco != null) {
            FieldIndexKeyContainer.KeyType keyType;
            FieldDefinition field = this.getMainField(repository);
            if (field != null) {
                keyType = field.isArray() ? FieldIndexKeyContainer.KeyType.VALUE_LIST : FieldIndexKeyContainer.KeyType.VALUE_MAP;
            } else {
                assert (this.myFieldStructure != null);
                keyType = this.myFieldStructure.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY ? FieldIndexKeyContainer.KeyType.VALUE_LIST : FieldIndexKeyContainer.KeyType.VALUE_MAP;
            }
            KeyValue[] keyValues = this.extractKeyValues(vfco);
            ret = this.formatFieldAndIndexSpec(repository, keyType, keyValues);
        }
        return ret;
    }

    private String getMainFieldNameForFormattedString() {
        return this.myExcludeMainField ? "" : this.myFieldName;
    }

    private Object getObjectValue(Object obj) {
        Object value = obj;
        if (obj instanceof Key) {
            Key key = (Key)obj;
            value = key.containsKey() ? key.getKey() : Integer.valueOf(key.getIndex());
        }
        return value;
    }

    private KeyValue[] extractKeyValues(ValueFieldCompositeObject vfco) {
        KeyValue[] keyValues;
        if (vfco instanceof MultipleValueFieldCompositeObject) {
            List objects = (List)vfco.getValueAsObject();
            keyValues = new KeyValue[objects.size()];
            for (int i = 0; i < keyValues.length; ++i) {
                keyValues[i] = new KeyValue((ValueFieldCompositeObject)objects.get(i));
            }
        } else {
            keyValues = new KeyValue[]{new KeyValue(vfco)};
        }
        return keyValues;
    }

    private KeyValue[] extractKeyValues(FieldIndexKeyContainer container, DataSet theData) {
        Object[] rawKeys = container.getRawKeys();
        Object[] values = null;
        if (theData != null && this.myUseDataSetResolution) {
            Key[] keys = container.getKeySet(theData);
            values = this.extractValuesFromKeys(keys);
        }
        assert (values == null || values.length == rawKeys.length);
        KeyValue[] keyValues = new KeyValue[rawKeys.length];
        for (int i = 0; i < rawKeys.length; ++i) {
            String fieldName = this.extractFieldNameFromRawKey(rawKeys[i]);
            Object rawValue = fieldName != null ? null : this.getObjectValue(rawKeys[i]);
            Object value = values != null ? values[i] : rawValue;
            keyValues[i] = new KeyValue(fieldName, value);
        }
        return keyValues;
    }

    private String extractFieldNameFromRawKey(Object object) {
        String name = null;
        if (FieldIndexKeyContainer.rawKeyRepresentsField(object)) {
            DataSetField field = FieldIndexKeyContainer.getFieldFromRawKey(object);
            name = field.getFieldName();
        }
        return name;
    }

    private ClassRepository extractRepository(DataSet theData) {
        ClassRepository repo = null;
        if (theData != null) {
            repo = theData.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(theData));
        }
        return repo;
    }

    private String formatFieldAndIndexSpec(ClassRepository repository, FieldIndexKeyContainer.KeyType keyType, KeyValue[] keyValues) {
        FieldHierarchyNode field;
        Object[] values = this.createIndexDisplayValues(repository, keyType, keyValues);
        FieldStructure parent = null;
        String fieldName = this.myFieldName;
        if (repository != null && (field = repository.getFieldRepository().getFieldByName(this.myFieldName)) != null) {
            fieldName = field.getFieldName();
            parent = field.getParent();
        }
        boolean useIndexOnParent = parent != null;
        StringBuilder builder = new StringBuilder();
        if (!this.myExcludeMainField) {
            String name = useIndexOnParent ? parent.getFieldName() : fieldName;
            builder.append(name).append("[");
        }
        builder.append(StringUtil.join(values, this.mySeparator));
        if (!this.myExcludeMainField) {
            builder.append("]");
            if (useIndexOnParent) {
                builder.append(".").append(fieldName);
            }
        }
        return builder.toString();
    }

    private IndexDisplayValue[] createIndexDisplayValues(ClassRepository repository, FieldIndexKeyContainer.KeyType keyType, KeyValue[] keyValues) {
        boolean useStrings;
        FieldDefinition parentField = null;
        String[] keyFieldNames = null;
        if (repository != null) {
            parentField = this.getMainField(repository);
            keyFieldNames = parentField != null ? parentField.getKeyFields() : null;
        }
        boolean isTypedMap = keyType == FieldIndexKeyContainer.KeyType.VALUE_MAP && keyFieldNames != null && keyFieldNames.length > 0;
        boolean bl = useStrings = keyType == FieldIndexKeyContainer.KeyType.VALUE_MAP && !isTypedMap;
        assert (!isTypedMap || keyFieldNames.length == keyValues.length) : "Expected " + keyFieldNames.length + " key values but got " + keyValues.length;
        IndexDisplayValue[] values = new IndexDisplayValue[keyValues.length];
        for (int i = 0; i < keyValues.length; ++i) {
            String originFieldName = keyValues[i].fieldName;
            FieldDefinition keyField = null;
            FieldDefinition originField = null;
            if (repository != null) {
                keyField = isTypedMap ? repository.getFieldDefinitionByName(keyFieldNames[i]) : null;
                originField = repository.getFieldDefinitionByName(originFieldName);
            }
            Object keyValue = keyValues[i].getValue(repository, keyField);
            values[i] = new IndexDisplayValue(keyType, originField, originFieldName, keyValue, keyField, useStrings);
        }
        return values;
    }

    private FieldDefinition getMainField(ClassRepository repository) {
        if (this.myField != null) {
            return this.myField;
        }
        assert (repository != null) : "Need a class repository at this point.";
        return repository.getFieldDefinitionByName(this.myFieldName);
    }

    private Object[] extractValuesFromKeys(Key[] keys) {
        Object[] keyValues;
        if (keys.length == 1 && keys[0].containsKey() && keys[0].getKey() instanceof ComplexKey) {
            ComplexKey ckey = (ComplexKey)keys[0].getKey();
            keyValues = new Object[ckey.getKeyLength()];
            for (int i = 0; i < keyValues.length; ++i) {
                keyValues[i] = ckey.getKeyObjectForIndex(i);
            }
        } else {
            keyValues = new Object[keys.length];
            for (int i = 0; i < keyValues.length; ++i) {
                keyValues[i] = this.getObjectValue(keys[i]);
            }
        }
        return keyValues;
    }

    private boolean valueNeedsQuoting(FieldIndexKeyContainer.KeyType keyType, Object vo) {
        if (keyType == FieldIndexKeyContainer.KeyType.VALUE_LIST || this.myField != null && this.myField.isArray()) {
            return false;
        }
        return vo instanceof String || vo instanceof BcdString;
    }

    private static class KeyValue {
        final Object value;
        final boolean valueNeedsParsing;
        final String fieldName;

        KeyValue(String fieldName, Object value) {
            this.fieldName = fieldName;
            this.value = value;
            this.valueNeedsParsing = false;
        }

        KeyValue(ValueFieldCompositeObject vfco) {
            if (vfco.getMode() == ValueFieldCompositeObject.Mode.Field) {
                this.fieldName = vfco.getFieldOrValueAsString();
                this.value = null;
                this.valueNeedsParsing = false;
            } else {
                this.fieldName = null;
                this.value = vfco.getValueAsObject();
                this.valueNeedsParsing = this.value == vfco.getFieldOrValueAsString();
            }
        }

        Object getValue(ClassRepository repository, FieldDefinition keyField) {
            Object obj = this.value;
            if (this.valueNeedsParsing && keyField != null) {
                ValueResolver resolver = FieldDefinitionUtil.createValueResolver(repository, keyField);
                obj = resolver.parseValueString((String)this.value);
            }
            return obj;
        }
    }

    private class IndexDisplayValue {
        private final Object myValue;
        private final FieldDefinition myKeyField;
        private final FieldDefinition myOriginField;
        private final String myOriginFieldName;
        private final FieldIndexKeyContainer.KeyType myKeyType;
        private final boolean myUseStringValue;

        IndexDisplayValue(FieldIndexKeyContainer.KeyType keyType, FieldDefinition originField, String originFieldName, Object value, FieldDefinition keyField, boolean useStringValue) {
            this.myKeyType = keyType;
            this.myOriginField = originField;
            this.myOriginFieldName = originFieldName;
            this.myValue = value;
            this.myKeyField = keyField;
            this.myUseStringValue = useStringValue;
        }

        public String toString() {
            String format = this.createDisplayStringFormat();
            String valueDisplay = this.createValueDisplayString();
            String str = String.format(format, this.myOriginFieldName, valueDisplay);
            return str;
        }

        private String createDisplayStringFormat() {
            boolean printValue;
            boolean hasValue = this.myValue != null;
            boolean hasField = this.myOriginFieldName != null;
            boolean printField = hasField && (FieldIndexFormatter.this.myIncludeIndexFieldName || !hasValue);
            boolean bl = printValue = hasValue && (FieldIndexFormatter.this.myIncludeIndexFieldValue || !hasField);
            String format = printField && printValue ? "%1$s (%2$s)" : (printField ? "%1$s" : "%2$s");
            return format;
        }

        private String createValueDisplayString() {
            if (this.myValue == null) {
                return null;
            }
            Object value = this.myUseStringValue ? String.valueOf(this.myValue) : this.myValue;
            boolean needsQuoting = FieldIndexFormatter.this.valueNeedsQuoting(this.myKeyType, value);
            StringBuilder builder = new StringBuilder();
            String displayValue = this.describeValue(value);
            String quote = this.deduceQuote(needsQuoting, displayValue);
            builder.append(quote).append(displayValue).append(quote);
            return builder.toString();
        }

        private String deduceQuote(boolean needsQuoting, String desc) {
            boolean quote = needsQuoting;
            if (quote && !desc.equalsIgnoreCase(String.valueOf(this.myValue))) {
                quote = false;
            }
            return quote ? "'" : "";
        }

        private String describeValue(Object value) {
            String description = String.valueOf(value);
            if (!this.myUseStringValue) {
                if (this.myOriginField != null) {
                    description = FieldIndexFormatter.this.myDataDescriber.describeObject(value, this.myOriginField);
                } else if (this.myKeyField != null) {
                    description = FieldIndexFormatter.this.myDataDescriber.describeObject(value, this.myKeyField);
                }
            }
            return description;
        }
    }
}

