/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.DefaultDataSetValueReader;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.UsedFieldLister;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

@Immutable
public class FieldIndexKeyContainer
implements UsedFieldLister {
    private final KeyType myKeyType;
    private final FieldDefinition[] myKeyFields;
    private final LazyKeySet myKeySet;

    public FieldIndexKeyContainer(ValueFieldCompositeObject vfco, KeyType keyType, ClassRepository repository) {
        this(vfco, keyType, repository, (FieldDefinition[])null);
    }

    public FieldIndexKeyContainer(ValueFieldCompositeObject vfco, KeyType keyType, ClassRepository repository, DataType keyDataType) {
        FieldDefinition[] fieldDefinitionArray;
        if (keyDataType != null) {
            FieldDefinition[] fieldDefinitionArray2 = new FieldDefinition[1];
            fieldDefinitionArray = fieldDefinitionArray2;
            fieldDefinitionArray2[0] = FieldIndexKeyContainer.createDynamicFieldDefinition(keyDataType);
        } else {
            fieldDefinitionArray = null;
        }
        this(vfco, keyType, repository, fieldDefinitionArray);
    }

    public FieldIndexKeyContainer(ValueFieldCompositeObject vfco, KeyType keyType, ClassRepository repository, FieldDefinition[] keyFields) {
        if (vfco == null || keyType == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        this.myKeyType = keyType;
        this.myKeyFields = keyFields;
        this.myKeySet = this.createLazyKeySet(vfco, repository);
    }

    public Key[] getKeySet(DataSet dataSet) {
        return this.getKeySet(dataSet, DefaultDataSetValueReader.INSTANCE);
    }

    public boolean keySetIsComplex() {
        return this.myKeySet.isComplex();
    }

    public Key[] getKeySet(DataSet dataSet, DataSetValueReader valueReader) {
        if (this.myKeySet.needsFinalEvaluation() && dataSet == null || valueReader == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        return this.myKeySet.evaluate(dataSet, valueReader);
    }

    public Object[] getRawKeys() {
        return this.myKeySet.myKeyContents != null ? this.myKeySet.myKeyContents : this.myKeySet.myPreparedKeys;
    }

    public static boolean rawKeyRepresentsField(Object rawKey) {
        return rawKey instanceof FieldWrapper;
    }

    public static DataSetField getFieldFromRawKey(Object rawKey) {
        if (!FieldIndexKeyContainer.rawKeyRepresentsField(rawKey)) {
            throw new IllegalArgumentException("The raw key does not contain a field.");
        }
        return ((FieldWrapper)rawKey).getDataSetField();
    }

    @Deprecated
    public Key getFirstKey(DataSet dataSet) {
        return this.getKeySet(dataSet)[0];
    }

    public KeyType getKeyType() {
        return this.myKeyType;
    }

    public String getKeyFieldName() {
        return this.myKeySet.getFieldNameForSingleKeyOrNull();
    }

    private List<Object> createKeysForValueVFCO(ValueFieldCompositeObject vfco, FieldDefinition keyField) {
        assert (vfco.getMode() == ValueFieldCompositeObject.Mode.Value);
        ArrayList<Object> objects = new ArrayList<Object>();
        switch (this.myKeyType) {
            case VALUE_LIST: {
                StringTokenizer tokenizer = new StringTokenizer(vfco.getFieldOrValueAsString(), " ,\u0000");
                LinkedHashSet<Key> set = new LinkedHashSet<Key>();
                while (tokenizer.hasMoreTokens()) {
                    String stringToken = tokenizer.nextToken();
                    if (stringToken.contains("-")) {
                        this.handleIndexRange(set, stringToken);
                        continue;
                    }
                    set.add(Key.asIndex(Integer.parseInt(stringToken)));
                }
                objects.addAll(set);
                break;
            }
            case VALUE_MAP: {
                objects.add(this.createObjectFromValue(vfco, keyField));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key type: " + (Object)((Object)this.myKeyType)));
            }
        }
        return objects;
    }

    private Object createObjectFromValue(ValueFieldCompositeObject vfco, FieldDefinition keyField) {
        Object keyValue;
        if (keyField != null) {
            keyValue = this.getValueObject(vfco, keyField);
            if (keyValue == null) {
                throw new IllegalArgumentException("Failed to convert '" + vfco.getFieldOrValueAsString() + "' to a value.");
            }
            DataType vfcoDataType = vfco.getValueDataType();
            if (vfcoDataType != null) {
                keyValue = FieldIndexKeyContainer.convertObjectToKeyDataType(keyValue, vfcoDataType, keyField.getTypedDataType());
            }
        } else {
            keyValue = vfco.getFieldOrValueAsString();
        }
        if (keyValue instanceof LazyEvaluatedValue) {
            return keyValue;
        }
        return Key.asKey(keyValue);
    }

    private Object getValueObject(ValueFieldCompositeObject vfco, FieldDefinition field) {
        Object object = null;
        if (vfco.getValueDataType() == null || field.hasValueClassFactory()) {
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(null, field);
            object = resolver.parseValueString(vfco.getFieldOrValueAsString());
        } else {
            object = vfco.getValueAsObject();
        }
        return object;
    }

    @Deprecated
    public static Object convertObjectToKeyDataType(Object keyValue, DataType currentType, FieldIndexKeyContainer fikc) {
        if (fikc.myKeyFields == null) {
            return FieldIndexKeyContainer.convertObjectToKeyDataType(keyValue, currentType, (DataType)null);
        }
        if (fikc.myKeyFields.length == 1) {
            return FieldIndexKeyContainer.convertObjectToKeyDataType(keyValue, currentType, fikc.myKeyFields[0].getTypedDataType());
        }
        throw new IllegalStateException("This FieldIndexKeyContainer contains a 'Complex key'. This is not handled by this method.");
    }

    private static Object convertObjectToKeyDataType(Object keyValue, DataType currentType, DataType keyFieldDataType) {
        Object ret = keyValue;
        if (keyFieldDataType != null && keyFieldDataType != currentType) {
            boolean error = false;
            try {
                ret = keyFieldDataType.castObject(keyValue);
                error = ret == null;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ClassCastException ex) {
                error = true;
            }
            if (error) {
                throw new IllegalArgumentException("Cannot convert '" + keyValue + "' to data type " + keyFieldDataType);
            }
        } else if (keyFieldDataType == null) {
            ret = String.valueOf(keyValue);
        }
        return ret;
    }

    private void handleIndexRange(Set<Key> set, String rangeString) {
        int secondInt;
        String[] rangeSplit = rangeString.split("-");
        if (rangeSplit.length != 2) {
            throw new IllegalArgumentException("The given range (" + rangeString + ") cannot be parsed.");
        }
        int firstInt = Integer.parseInt(rangeSplit[0]);
        if (firstInt > (secondInt = Integer.parseInt(rangeSplit[1]))) {
            throw new IllegalArgumentException("The given range (" + rangeString + ") is in the wrong order.");
        }
        for (int currentInt = firstInt; currentInt <= secondInt; ++currentInt) {
            set.add(Key.asIndex(currentInt));
        }
    }

    private static Key fetchFieldValueAndCreateKey(FieldWrapper fieldWrapper, DataSetValueReader valueReader, DataSet dataSet, KeyType keyType) {
        DataSetField field = fieldWrapper.getDataSetField();
        Object keyValue = valueReader.getValueFromDataSet(dataSet, field, null);
        switch (keyType) {
            case VALUE_LIST: {
                int indexValue = keyValue instanceof Number ? ((Number)keyValue).intValue() : Integer.parseInt(String.valueOf(keyValue));
                return Key.asIndex(indexValue);
            }
            case VALUE_MAP: {
                Object convertedValue = FieldIndexKeyContainer.convertObjectToKeyDataType(keyValue, field.getDataType(), fieldWrapper.getOverrideDataType());
                return Key.asKey(convertedValue);
            }
        }
        throw new AssertionError((Object)("Type is not supported: " + (Object)((Object)keyType)));
    }

    private LazyKeySet createLazyKeySet(ValueFieldCompositeObject vfco, ClassRepository repository) {
        ArrayList<Object> keyObjectList = new ArrayList<Object>();
        if (vfco instanceof MultipleValueFieldCompositeObject) {
            Object valueAsObject = ((MultipleValueFieldCompositeObject)vfco).getValueAsObject();
            List vfcoList = (List)valueAsObject;
            assert (this.myKeyFields == null || this.myKeyFields.length == vfcoList.size()) : "Unsync between vfco and field array";
            for (int i = 0; i < vfcoList.size(); ++i) {
                ValueFieldCompositeObject o = (ValueFieldCompositeObject)vfcoList.get(i);
                FieldDefinition keyField = this.myKeyFields != null ? this.myKeyFields[i] : null;
                keyObjectList.addAll(this.extractObjectsFromVFCO(o, keyField, repository));
            }
        } else {
            FieldDefinition keyField = this.myKeyFields != null && this.myKeyFields.length > 0 ? this.myKeyFields[0] : null;
            keyObjectList.addAll(this.extractObjectsFromVFCO(vfco, keyField, repository));
        }
        return new LazyKeySet(this.myKeyType, keyObjectList);
    }

    private List<Object> extractObjectsFromVFCO(ValueFieldCompositeObject vfco, FieldDefinition keyField, ClassRepository repository) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        switch (vfco.getMode()) {
            case Value: {
                objectList.addAll(this.createKeysForValueVFCO(vfco, keyField));
                break;
            }
            case Field: {
                objectList.add(this.createFieldWrapper(vfco.getFieldOrValueAsString(), repository, keyField));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown mode: " + (Object)((Object)vfco.getMode())));
            }
        }
        return objectList;
    }

    private FieldWrapper createFieldWrapper(String fieldName, ClassRepository repository, FieldDefinition keyField) {
        if (repository == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        FieldDefinition fieldDefinition = repository.getFieldDefinitionByName(fieldName);
        if (fieldDefinition == null) {
            throw new IllegalArgumentException("Field not found: " + fieldName);
        }
        return new FieldWrapper(new DataSetField(fieldDefinition), keyField != null ? keyField.getTypedDataType() : null);
    }

    private static FieldDefinition createDynamicFieldDefinition(DataType keyDataType) {
        return new FieldDefinition("unnamed", keyDataType.getTypeIdentifier(), false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.myKeyFields);
        result = 31 * result + (this.myKeySet == null ? 0 : this.myKeySet.hashCode());
        result = 31 * result + (this.myKeyType == null ? 0 : this.myKeyType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldIndexKeyContainer other = (FieldIndexKeyContainer)obj;
        if (!Arrays.equals(this.myKeyFields, other.myKeyFields)) {
            return false;
        }
        if (this.myKeySet == null ? other.myKeySet != null : !this.myKeySet.equals(other.myKeySet)) {
            return false;
        }
        return !(this.myKeyType == null ? other.myKeyType != null : !this.myKeyType.equals((Object)other.myKeyType));
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> set = new HashSet<String>();
        for (Object key : this.getRawKeys()) {
            if (!FieldIndexKeyContainer.rawKeyRepresentsField(key)) continue;
            set.add(FieldIndexKeyContainer.getFieldFromRawKey(key).getFieldName());
        }
        return set;
    }

    @Immutable
    public static class FieldWrapper {
        private final DataSetField myField;
        private final DataType myOverrideDataType;

        private FieldWrapper(DataSetField field, DataType overrideDataType) {
            this.myField = field;
            this.myOverrideDataType = overrideDataType;
        }

        public DataSetField getDataSetField() {
            return this.myField;
        }

        public DataType getOverrideDataType() {
            return this.myOverrideDataType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
            result = 31 * result + (this.myOverrideDataType == null ? 0 : this.myOverrideDataType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldWrapper other = (FieldWrapper)obj;
            if (this.myField == null ? other.myField != null : !this.myField.equals(other.myField)) {
                return false;
            }
            return !(this.myOverrideDataType == null ? other.myOverrideDataType != null : !this.myOverrideDataType.equals(other.myOverrideDataType));
        }
    }

    @Immutable
    private static class LazyKeySet {
        private final Object[] myKeyContents;
        private final Key[] myPreparedKeys;
        private final KeyType keyType;

        private LazyKeySet(KeyType keyType, List<Object> objectList) {
            assert (objectList != null && objectList.size() > 0) : "List must be non-null, non-empty";
            this.keyType = keyType;
            ArrayList<Object> keyObjectList = new ArrayList<Object>();
            boolean needsFinalEvaluation = false;
            for (Object currentObject : objectList) {
                if (!needsFinalEvaluation && !(currentObject instanceof Key)) {
                    needsFinalEvaluation = true;
                }
                keyObjectList.add(currentObject);
            }
            if (needsFinalEvaluation) {
                this.myKeyContents = keyObjectList.toArray(new Object[keyObjectList.size()]);
                this.myPreparedKeys = null;
            } else {
                this.myKeyContents = null;
                this.myPreparedKeys = keyObjectList.toArray(new Key[keyObjectList.size()]);
            }
        }

        private boolean isComplex() {
            if (this.myKeyContents != null) {
                return this.arrayRepresentsComplexKey(this.myKeyContents);
            }
            if (this.myPreparedKeys != null) {
                return this.arrayRepresentsComplexKey(this.myPreparedKeys);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Key[] evaluate(DataSet dataSet, DataSetValueReader valueReader) {
            Key[] keys = null;
            if (this.myPreparedKeys != null) {
                if (!this.arrayRepresentsComplexKey(this.myPreparedKeys)) return this.myPreparedKeys;
                Object[] objects = new Object[this.myPreparedKeys.length];
                for (int i = 0; i < this.myPreparedKeys.length; ++i) {
                    objects[i] = this.myPreparedKeys[i].getKey();
                }
                return new Key[]{Key.asKey(ComplexKey.createComplexKeyWithValues(objects))};
            }
            if (this.myKeyContents == null) return keys;
            if (!this.arrayRepresentsComplexKey(this.myKeyContents)) return new Key[]{this.createKeyFromObject(this.myKeyContents[0], valueReader, dataSet)};
            Object[] objects = new Object[this.myKeyContents.length];
            for (int i = 0; i < this.myKeyContents.length; ++i) {
                objects[i] = this.createKeyFromObject(this.myKeyContents[i], valueReader, dataSet).getKey();
            }
            return new Key[]{Key.asKey(ComplexKey.createComplexKeyWithValues(objects))};
        }

        private Key createKeyFromObject(Object object, DataSetValueReader valueReader, DataSet dataSet) {
            if (object instanceof Key) {
                return (Key)object;
            }
            if (object instanceof FieldWrapper) {
                return FieldIndexKeyContainer.fetchFieldValueAndCreateKey((FieldWrapper)object, valueReader, dataSet, this.keyType);
            }
            if (object instanceof LazyEvaluatedValue) {
                return Key.asKey(((LazyEvaluatedValue)object).evaluate(dataSet));
            }
            throw new AssertionError((Object)("Unsupported object type: " + object.getClass()));
        }

        private boolean arrayRepresentsComplexKey(Object[] objectArray) {
            return this.keyType == KeyType.VALUE_MAP && objectArray.length > 1;
        }

        private boolean needsFinalEvaluation() {
            return this.myPreparedKeys == null;
        }

        private String getFieldNameForSingleKeyOrNull() {
            if (this.myKeyContents != null && this.myKeyContents.length == 1) {
                Object o = this.myKeyContents[0];
                return o instanceof FieldWrapper ? ((FieldWrapper)o).getDataSetField().getFieldName() : null;
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
            result = 31 * result + Arrays.hashCode(this.myKeyContents);
            result = 31 * result + Arrays.hashCode(this.myPreparedKeys);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LazyKeySet other = (LazyKeySet)obj;
            if (this.keyType == null ? other.keyType != null : !this.keyType.equals((Object)other.keyType)) {
                return false;
            }
            if (!Arrays.equals(this.myKeyContents, other.myKeyContents)) {
                return false;
            }
            return Arrays.equals(this.myPreparedKeys, other.myPreparedKeys);
        }
    }

    public static enum KeyType {
        VALUE_LIST,
        VALUE_MAP;

    }
}

