/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.util;

public class OperatorUtil {
    public static final String[] operatorString = new String[]{"=", ">", "<", ">=", "<="};
    private static final String[] tokenOperatorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};

    public static String operatorToToken(String operator) {
        for (int i = 0; i < operatorString.length; ++i) {
            if (!operatorString[i].equals(operator)) continue;
            return tokenOperatorArr[i];
        }
        return operator;
    }

    public static String tokenToOperator(String token) {
        for (int i = 0; i < tokenOperatorArr.length; ++i) {
            if (!tokenOperatorArr[i].equals(token)) continue;
            return operatorString[i];
        }
        return token;
    }

    public static int getOperatorAsInt(String operator) {
        for (int i = 0; i < operatorString.length; ++i) {
            if (!operator.equals(operatorString[i])) continue;
            return i;
        }
        return 0;
    }

    public static Operator getOperatorAsEnum(String operator) {
        return Operator.values()[OperatorUtil.getOperatorAsInt(operator)];
    }

    @Deprecated
    public static int getTokenAsInt(String token) {
        return OperatorUtil.getOperatorAsInt(token);
    }

    public static enum Operator {
        EQ{

            @Override
            public boolean test(long op1, long op2) {
                return op1 == op2;
            }
        }
        ,
        GT{

            @Override
            public boolean test(long op1, long op2) {
                return op1 > op2;
            }
        }
        ,
        LT{

            @Override
            public boolean test(long op1, long op2) {
                return op1 < op2;
            }
        }
        ,
        GTE{

            @Override
            public boolean test(long op1, long op2) {
                return op1 >= op2;
            }
        }
        ,
        LTE{

            @Override
            public boolean test(long op1, long op2) {
                return op1 <= op2;
            }
        };


        public abstract boolean test(long var1, long var3);
    }
}

