/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class SelfUpdatingMemoryViewer
extends JProgressBar {
    private Color myNormalForegroundColor = Color.green.darker();
    private Color myWarningForegroundColor = Color.red;
    private Color myBackgroundColor = Color.lightGray;
    private Color myTextColor = Color.black;
    private int myWarningLimit = 90;
    private ScheduledExecutorService myExecutor = Executors.newScheduledThreadPool(1);
    private Runnable myMemoryUpdater = new MemoryUpdater();
    private int myIntervalSeconds;
    private ScheduledFuture<?> myRefresher;

    public SelfUpdatingMemoryViewer(int intervalSeconds) {
        super(0, 0, 100);
        if (intervalSeconds <= 0) {
            throw new IllegalArgumentException("Invalid interval, must be greater than zero.");
        }
        this.myIntervalSeconds = intervalSeconds;
        this.configure();
    }

    private void configure() {
        this.setUI(new CustomProgressBarUI());
        this.setBackground(this.myBackgroundColor);
        this.setForeground(this.myNormalForegroundColor);
        Font current = this.getFont();
        this.setFont(current.deriveFont(current.getSize2D() * 0.8f));
        this.setStringPainted(true);
    }

    void refresh() {
        SwingUtilities.invokeLater(this.myMemoryUpdater);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stopSelfUpdate();
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.startSelfUpdate();
        } else {
            this.stopSelfUpdate();
        }
    }

    public void setNormalForegroundColor(Color normalForegroundColor) {
        this.myNormalForegroundColor = normalForegroundColor;
    }

    public void setWarningForegroundColor(Color warningForegroundColor) {
        this.myWarningForegroundColor = warningForegroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.myBackgroundColor = backgroundColor;
    }

    public void setTextColor(Color textColor) {
        this.myTextColor = textColor;
    }

    public void setWarningLimit(int warningLimit) {
        this.myWarningLimit = warningLimit;
    }

    public synchronized void startSelfUpdate() {
        if (this.myRefresher == null) {
            this.myRefresher = this.myExecutor.scheduleAtFixedRate(new PeriodicRefresher(), 0L, this.myIntervalSeconds, TimeUnit.SECONDS);
        }
    }

    public synchronized void stopSelfUpdate() {
        if (this.myRefresher != null) {
            this.myRefresher.cancel(false);
            this.myRefresher = null;
        }
    }

    private class CustomProgressBarUI
    extends BasicProgressBarUI {
        private CustomProgressBarUI() {
        }

        @Override
        protected Color getSelectionBackground() {
            return SelfUpdatingMemoryViewer.this.myTextColor;
        }

        @Override
        protected Color getSelectionForeground() {
            return SelfUpdatingMemoryViewer.this.myTextColor;
        }

        @Override
        protected Point getStringPlacement(Graphics g, String progressString, int x, int y, int width, int height) {
            Point p = super.getStringPlacement(g, progressString, x, y, width, height);
            p.x = SelfUpdatingMemoryViewer.this.getInsets().left;
            return p;
        }
    }

    private class MemoryUpdater
    implements Runnable {
        private MemoryUpdater() {
        }

        @Override
        public void run() {
            long[] usedAndTotalMemory = this.getUsedAndTotalMemory();
            long used = usedAndTotalMemory[0];
            long total = usedAndTotalMemory[1];
            int pct = (int)(100L * used / total);
            this.updateProgress(pct);
            this.updateColors(pct);
            this.setProgressText(pct);
        }

        private void updateColors(int pct) {
            boolean warn = pct >= SelfUpdatingMemoryViewer.this.myWarningLimit;
            SelfUpdatingMemoryViewer.this.setForeground(warn ? SelfUpdatingMemoryViewer.this.myWarningForegroundColor : SelfUpdatingMemoryViewer.this.myNormalForegroundColor);
        }

        private void setProgressText(int pct) {
            String text = String.format("Used memory: %d%%", pct);
            SelfUpdatingMemoryViewer.this.setString(text);
        }

        private void updateProgress(int progress) {
            SelfUpdatingMemoryViewer.this.setValue(progress);
        }

        private long[] getUsedAndTotalMemory() {
            Runtime rt = Runtime.getRuntime();
            long totalMem = rt.totalMemory();
            long usedMem = rt.totalMemory() - rt.freeMemory();
            return new long[]{usedMem, totalMem};
        }
    }

    private class PeriodicRefresher
    implements Runnable {
        private PeriodicRefresher() {
        }

        @Override
        public void run() {
            SelfUpdatingMemoryViewer.this.refresh();
        }
    }
}

