/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.swing;

import com.ericsson.ere.swing.TreeModelAdapter;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TreeModelMonitor
extends TreeModelAdapter {
    private Runnable myOnInsert;
    private Runnable myOnRemove;
    private Object myNode;
    private TreeModel myModel;

    public TreeModelMonitor(TreeModel model, Object node) {
        model.addTreeModelListener(this);
        this.myModel = model;
        this.myNode = node;
    }

    public TreeModelMonitor onInsert(Runnable r) {
        this.myOnInsert = r;
        return this;
    }

    public TreeModelMonitor onRemove(Runnable r) {
        this.myOnRemove = r;
        return this;
    }

    public void detach() {
        this.myModel.removeTreeModelListener(this);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.trigger(e.getChildren(), this.myOnInsert);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.trigger(e.getChildren(), this.myOnRemove);
    }

    private void trigger(Object[] children, Runnable r) {
        if (r != null) {
            for (Object child : children) {
                if (!this.contains(child, this.myNode)) continue;
                r.run();
                break;
            }
        }
    }

    protected boolean contains(Object haystackRoot, Object needle) {
        assert (haystackRoot instanceof TreeNode && needle instanceof TreeNode) : "Cannot handle non-TreeNodes, contains must be overridden.";
        return this.containsTreeNode((TreeNode)haystackRoot, (TreeNode)needle);
    }

    private boolean containsTreeNode(TreeNode haystackRoot, TreeNode needle) {
        boolean found = haystackRoot == needle;
        for (int i = 0; !found && i < haystackRoot.getChildCount(); ++i) {
            TreeNode child = haystackRoot.getChildAt(i);
            found = this.containsTreeNode(child, needle);
        }
        return found;
    }
}

