/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.trace.filter;

import com.ericsson.ere.trace.filter.TraceFilter;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class AbstractTraceFilter
implements TraceFilter {
    protected boolean myIsBold = false;
    protected boolean myIsItalic = false;
    protected boolean myIsMonospace = false;
    protected boolean myIsTable = false;
    protected boolean myIsTableHeader = false;
    protected boolean myTableHeaderWritten = false;
    protected boolean myIsTableRow = false;
    protected boolean myIsTableCell = false;
    protected boolean myIsHeader = false;
    protected int myHeaderLevel = 0;
    protected boolean myIsHighlighted = false;

    protected AbstractTraceFilter() {
    }

    @Override
    public String filterTrace(String parTrace) {
        if (parTrace != null) {
            StringWriter theWriter = new StringWriter();
            PrintWriter thePrintWriter = new PrintWriter(theWriter);
            int theIndex = -1;
            int theLastIndex = 0;
            int theLastNewLineIndex = -1;
            String[] theKeys = new String[]{"----", "$$", "__", "{{", "}}", "''", "!", "|", "\n", "\r"};
            while ((theIndex = this.getIndexOf(parTrace, theLastIndex, theKeys)) >= 0) {
                if (theLastIndex != theIndex) {
                    if (this.myIsTable && !this.myIsTableRow) {
                        this.endTable(thePrintWriter);
                        this.myIsTable = false;
                        this.myIsTableCell = false;
                        this.myIsTableRow = false;
                        this.myIsTableHeader = false;
                    }
                    this.print(parTrace.substring(theLastIndex, theIndex), thePrintWriter);
                }
                if (parTrace.startsWith("----", theIndex)) {
                    theLastIndex = theIndex + 4;
                    this.horizontalRuler(thePrintWriter);
                    continue;
                }
                if (parTrace.startsWith("__", theIndex)) {
                    theLastIndex = theIndex + 2;
                    if (this.myIsBold) {
                        this.endBold(thePrintWriter);
                    } else {
                        this.beginBold(thePrintWriter);
                    }
                    this.myIsBold = !this.myIsBold;
                    continue;
                }
                if (parTrace.startsWith("''", theIndex)) {
                    theLastIndex = theIndex + 2;
                    if (this.myIsItalic) {
                        this.endItalic(thePrintWriter);
                    } else {
                        this.beginItalic(thePrintWriter);
                    }
                    this.myIsItalic = !this.myIsItalic;
                    continue;
                }
                if (parTrace.startsWith("{{", theIndex)) {
                    theLastIndex = theIndex + 2;
                    this.beginMonospace(thePrintWriter);
                    this.myIsMonospace = true;
                    continue;
                }
                if (parTrace.startsWith("}}", theIndex)) {
                    theLastIndex = theIndex + 2;
                    this.endMonospace(thePrintWriter);
                    this.myIsMonospace = false;
                    continue;
                }
                if (parTrace.startsWith("!!!", theIndex) && theLastNewLineIndex == theIndex - 1) {
                    theLastIndex = theIndex + 3;
                    this.beginHeader(3, thePrintWriter);
                    this.myIsHeader = true;
                    this.myHeaderLevel = 3;
                    continue;
                }
                if (parTrace.startsWith("!!", theIndex) && theLastNewLineIndex == theIndex - 1) {
                    theLastIndex = theIndex + 2;
                    this.beginHeader(2, thePrintWriter);
                    this.myIsHeader = true;
                    this.myHeaderLevel = 2;
                    continue;
                }
                if (parTrace.startsWith("!", theIndex) && theLastNewLineIndex == theIndex - 1) {
                    theLastIndex = theIndex + 1;
                    this.beginHeader(1, thePrintWriter);
                    this.myIsHeader = true;
                    this.myHeaderLevel = 1;
                    continue;
                }
                if (parTrace.startsWith("!", theIndex)) {
                    theLastIndex = theIndex + 1;
                    this.print("!", thePrintWriter);
                    continue;
                }
                if (parTrace.startsWith("$$", theIndex)) {
                    theLastIndex = theIndex + 2;
                    if (this.myIsHighlighted) {
                        this.endHighlight(thePrintWriter);
                    } else {
                        this.beginHighlight(thePrintWriter);
                    }
                    this.myIsHighlighted = !this.myIsHighlighted;
                    continue;
                }
                if (parTrace.startsWith("||", theIndex)) {
                    if (!this.myIsTable) {
                        this.beginTable(thePrintWriter);
                        this.myIsTable = true;
                        this.myIsTableRow = true;
                        this.beginTableRow(thePrintWriter);
                        this.beginTableHeader(thePrintWriter);
                        this.myIsTableHeader = true;
                        this.myTableHeaderWritten = true;
                    } else if (this.myIsTableHeader) {
                        if (this.myIsHeader) {
                            this.endHeader(this.myHeaderLevel, thePrintWriter);
                            this.myIsHeader = false;
                        }
                        this.endTableHeader(thePrintWriter);
                        this.myIsTableHeader = false;
                        if (!parTrace.startsWith("\n", theIndex + 2) && !parTrace.startsWith("\r", theIndex + 2)) {
                            this.beginTableHeader(thePrintWriter);
                            this.myIsTableHeader = true;
                        }
                    } else {
                        if (!this.myIsTableRow) {
                            this.myIsTableRow = true;
                            this.beginTableRow(thePrintWriter);
                        }
                        if (this.myIsTableCell) {
                            if (this.myIsHeader) {
                                this.endHeader(this.myHeaderLevel, thePrintWriter);
                                this.myIsHeader = false;
                            }
                            this.endTableCell(thePrintWriter);
                            this.myIsTableCell = false;
                            if (!parTrace.startsWith("\n", theIndex + 1) && !parTrace.startsWith("\r", theIndex + 1)) {
                                this.beginTableCell(thePrintWriter);
                                this.myIsTableCell = true;
                                this.space(thePrintWriter);
                            }
                        } else {
                            this.beginTableCell(thePrintWriter);
                            this.myIsTableCell = true;
                        }
                        theLastIndex = theIndex + 1;
                        continue;
                    }
                    theLastIndex = theIndex + 2;
                    continue;
                }
                if (parTrace.startsWith("|", theIndex)) {
                    if (!this.myIsTableRow) {
                        this.myIsTableRow = true;
                        this.beginTableRow(thePrintWriter);
                    }
                    if (this.myIsTableCell) {
                        if (this.myIsHeader) {
                            this.endHeader(this.myHeaderLevel, thePrintWriter);
                            this.myIsHeader = false;
                        }
                        this.endTableCell(thePrintWriter);
                        this.myIsTableCell = false;
                        if (!parTrace.startsWith("\n", theIndex + 1) && !parTrace.startsWith("\r", theIndex + 1)) {
                            this.beginTableCell(thePrintWriter);
                            this.myIsTableCell = true;
                        }
                    } else {
                        this.beginTableCell(thePrintWriter);
                        this.myIsTableCell = true;
                    }
                    theLastIndex = theIndex + 1;
                    continue;
                }
                if (parTrace.startsWith("\n", theIndex)) {
                    theLastNewLineIndex = theIndex;
                    if (this.myIsHeader) {
                        this.endHeader(this.myHeaderLevel, thePrintWriter);
                        this.myIsHeader = false;
                        theLastIndex = theIndex + 1;
                        continue;
                    }
                    if (!this.myIsTable) {
                        this.newline(thePrintWriter);
                    } else if (this.myIsTableRow) {
                        if (this.myIsTableCell) {
                            this.endTableCell(thePrintWriter);
                            this.myIsTableCell = false;
                        }
                        if (this.myIsTableHeader) {
                            this.endTableHeader(thePrintWriter);
                            this.myIsTableHeader = false;
                        }
                        this.endTableRow(thePrintWriter);
                        this.myIsTableRow = false;
                    } else {
                        this.endTable(thePrintWriter);
                        this.myIsTable = false;
                        this.myIsTableRow = false;
                        this.myIsTableHeader = false;
                        this.myIsTableCell = false;
                        this.myTableHeaderWritten = false;
                    }
                    theLastIndex = theIndex + 1;
                    continue;
                }
                if (parTrace.startsWith("\r", theIndex)) {
                    theLastIndex = theIndex + 1;
                    continue;
                }
                theLastIndex = theIndex + 1;
            }
            if (this.myIsHeader) {
                this.endHeader(this.myHeaderLevel, thePrintWriter);
                this.myIsHeader = false;
            }
            if (this.myIsTable) {
                if (this.myIsTableRow) {
                    this.endTableRow(thePrintWriter);
                }
                this.endTable(thePrintWriter);
            }
            this.print(parTrace.substring(theLastIndex), thePrintWriter);
            thePrintWriter.println();
            thePrintWriter.flush();
            return theWriter.toString();
        }
        return "";
    }

    private int getIndexOf(String parTrace, int parOffset, String[] parTokens) {
        for (int i = parOffset; i < parTrace.length(); ++i) {
            for (int j = 0; j < parTokens.length; ++j) {
                if (!parTrace.startsWith(parTokens[j], i)) continue;
                return i;
            }
        }
        return -1;
    }

    protected abstract void beginTrace(PrintWriter var1);

    protected abstract void print(String var1, PrintWriter var2);

    protected abstract void beginHeader(int var1, PrintWriter var2);

    protected abstract void endHeader(int var1, PrintWriter var2);

    protected abstract void beginBold(PrintWriter var1);

    protected abstract void endBold(PrintWriter var1);

    protected abstract void beginItalic(PrintWriter var1);

    protected abstract void endItalic(PrintWriter var1);

    protected abstract void beginHighlight(PrintWriter var1);

    protected abstract void endHighlight(PrintWriter var1);

    protected abstract void beginMonospace(PrintWriter var1);

    protected abstract void endMonospace(PrintWriter var1);

    protected abstract void beginTable(PrintWriter var1);

    protected abstract void beginTableHeader(PrintWriter var1);

    protected abstract void endTableHeader(PrintWriter var1);

    protected abstract void beginTableRow(PrintWriter var1);

    protected abstract void beginTableCell(PrintWriter var1);

    protected abstract void endTableCell(PrintWriter var1);

    protected abstract void endTableRow(PrintWriter var1);

    protected abstract void endTable(PrintWriter var1);

    protected abstract void newline(PrintWriter var1);

    protected abstract void space(PrintWriter var1);

    protected abstract void horizontalRuler(PrintWriter var1);

    protected abstract void endTrace(PrintWriter var1);
}

