/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResourceFromClassCodeSource(Class<?> clazz, String resourceName) throws IOException {
        String resolvedName = ResourceUtil.resolveName(clazz, resourceName);
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        if (cs == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no code source.");
        }
        URL classURL = cs.getLocation();
        URL result = null;
        ArrayList<URL> resourceURLs = Collections.list(clazz.getClassLoader().getResources(resolvedName));
        for (URL resourceURL : resourceURLs) {
            if (!ResourceUtil.isURLExtensionOf(classURL, resourceURL)) continue;
            result = resourceURL;
            break;
        }
        if (result == null && resourceURLs.size() == 1) {
            result = (URL)resourceURLs.get(0);
        }
        return result;
    }

    private static String resolveName(Class<?> clazz, String name) {
        String result = name;
        if (result == null) {
            return result;
        }
        if (!result.startsWith("/")) {
            Class<?> c = clazz;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                result = baseName.substring(0, index).replace('.', '/') + "/" + result;
            }
        } else {
            result = result.substring(1);
        }
        return result;
    }

    public static boolean isURLExtensionOf(URL base, URL extension) throws MalformedURLException {
        URI rel;
        URI baseURI = ResourceUtil.convertURLToURI(ResourceUtil.dejarify(base));
        URI extURI = ResourceUtil.convertURLToURI(ResourceUtil.dejarify(extension));
        if (ResourceUtil.isRelativeFileURI(baseURI) && ResourceUtil.isRelativeFileURI(extURI)) {
            baseURI = ResourceUtil.makeFakeNonOpaqueURI(baseURI);
            extURI = ResourceUtil.makeFakeNonOpaqueURI(extURI);
        }
        return (rel = baseURI.relativize(extURI)) != extURI && rel.getScheme() == null;
    }

    private static boolean isRelativeFileURI(URI uri) {
        return uri.isOpaque() && "file".equals(uri.getScheme());
    }

    private static URI makeFakeNonOpaqueURI(URI uri) {
        String scheme = uri.getScheme();
        String rest = uri.getSchemeSpecificPart();
        try {
            return new URI(scheme + ":/" + rest);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Cannot make non-opaque: " + uri);
        }
    }

    private static URL dejarify(URL extension) throws MalformedURLException {
        URL ret = extension;
        if ("jar".equals(extension.getProtocol())) {
            String s = extension.getFile();
            s = s.replaceFirst("!/", "/");
            ret = new URL(s);
        }
        return ret;
    }

    private static URI convertURLToURI(URL u) {
        try {
            return u.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URL, cannot convert to URI: " + u);
        }
    }
}

