/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.faultindication;

public interface FaultIndicationDescription {
    public static final int ERICSSON_VENDOR_CODE = 193;

    public String getFaultName();

    public String getDefaultDescription();

    public int getDefaultExpiration();

    public Severity getDefaultSeverity();

    default public int getVendor() {
        return 193;
    }

    public int getCode();

    public Category getCategory();

    public int getProbableCause();

    public String getSpecificProblem();

    default public boolean isAutoCleared() {
        return false;
    }

    public static enum Category {
        OTHER("Other"),
        COMMUNICATIONS_ALARM("CommunicationsAlarm"),
        QUALITY_OF_SERVICE_ALARM("QualityOfServiceAlarm"),
        PROCESSING_ERROR_ALARM("ProcessingErrorAlarm"),
        EQUIPMENT_ALARM("EquipmentAlarm"),
        ENVIRONMENTAL_ALARM("EnvironmentalAlarm"),
        INTEGRITY_VIOLATION("IntegrityViolation"),
        OPERATIONAL_VIOLATION("OperationalViolation"),
        PHYSICAL_VIOLATION("PhysicalViolation"),
        SECURITY_SERVICE_OR_MECHANISM_VIOLATION("SecurityServiceOrMechanismViolation"),
        TIME_DOMAIN_VIOLATION("TimeDomainViolation");

        private final String mappingName;

        private Category(String mappingName) {
            this.mappingName = mappingName;
        }

        public String toString() {
            return this.mappingName;
        }
    }

    public static enum Severity {
        CLEAR("Clear"),
        WARNING("Warning"),
        MINOR("Minor"),
        MAJOR("Major"),
        CRITICAL("Critical");

        private final String mappingName;

        private Severity(String mappingName) {
            this.mappingName = mappingName;
        }

        public String toString() {
            return this.mappingName;
        }
    }
}

