/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.AcceptHeaderHandler;
import com.ericsson.lwac.http.types.Version;
import com.google.common.base.Strings;
import jakarta.ejb.Singleton;
import jakarta.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public class AcceptHeaderHandlerBean
implements AcceptHeaderHandler {
    private static final String VERSION = "version";
    private static final String QUALITY = "q";

    @Override
    public Optional<Version> getPreferredVersion(String acceptHeader, String contentType) {
        MediaType expectedContentType = this.parse(contentType);
        try {
            Map<MediaType, String> acceptedTypes = this.getAcceptedContextTypeAndQuality(acceptHeader);
            Optional<Version> prefferedVersion = acceptedTypes.entrySet().stream().filter(entry -> ((MediaType)entry.getKey()).isCompatible(expectedContentType)).max(Comparator.nullsFirst(Comparator.comparingDouble(entry -> Double.valueOf((String)entry.getValue())))).map(entry -> this.typeToVersion((MediaType)entry.getKey()));
            return prefferedVersion;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Quality parameter is not in Double format.");
        }
    }

    @Override
    public List<Version> getAcceptableVersions(String acceptHeader, String contentType) {
        MediaType expectedContentType = this.parse(contentType);
        List<MediaType> mediaTypes = this.getAcceptedContextTypes(acceptHeader);
        List<Version> versions = mediaTypes.stream().filter(mediaType -> mediaType.isCompatible(expectedContentType)).filter(mediaType -> this.hasNonEmptyParameter((MediaType)mediaType, VERSION)).map(this::typeToVersion).collect(Collectors.toList());
        return versions;
    }

    @Override
    public List<MediaType> getAcceptedContextTypes(String acceptHeader) {
        List<MediaType> mediaTypes = Arrays.stream(acceptHeader.split(",")).map(String::trim).map(this::parse).collect(Collectors.toList());
        return mediaTypes;
    }

    @Override
    public Map<MediaType, String> getAcceptedContextTypeAndQuality(String acceptHeader) {
        return Arrays.stream(acceptHeader.split(",")).map(String::trim).map(this::parse).collect(Collectors.toMap(mediaType -> mediaType, this::typeToQuality));
    }

    private Optional<String> typeToParam(MediaType mediaType, String paramName) {
        String param = (String)mediaType.getParameters().get(paramName);
        return Optional.ofNullable(param);
    }

    private Version typeToVersion(MediaType mediaType) {
        Optional<String> version = this.typeToParam(mediaType, VERSION);
        return version.map(Version::fromString).orElse(null);
    }

    private String typeToQuality(MediaType mediaType) {
        Optional<String> quality = this.typeToParam(mediaType, QUALITY);
        return quality.orElse("");
    }

    private boolean hasNonEmptyParameter(MediaType mediaType, String parameter) {
        return !Strings.isNullOrEmpty((String)mediaType.getParameters().get(parameter));
    }

    public MediaType parse(String value) {
        List<String> parts = Arrays.asList(value.split(";"));
        if (parts.isEmpty()) {
            return null;
        }
        if (!parts.get(0).contains("/")) {
            throw new IllegalArgumentException("missing type and subtype");
        }
        String[] type = parts.get(0).split("/");
        Map<String, String> parameters = parts.subList(1, parts.size()).stream().map(String::trim).map(part -> part.split("=")).collect(Collectors.toMap(part -> part[0], part -> part[1]));
        return new MediaType(type[0], type[1], parameters);
    }
}

