/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http;

import com.ericsson.lwac.http.AsyncHttpOperation;
import com.ericsson.lwac.http.CallContext;
import com.ericsson.lwac.http.HttpOperation;
import com.ericsson.lwac.http.HttpOperationBase;
import com.ericsson.lwac.http.HttpOperationCallContext;
import com.ericsson.lwac.http.HttpOperationRequest;
import com.ericsson.lwac.http.HttpOperationResponse;
import com.ericsson.lwac.http.HttpOperationServiceListener;
import com.ericsson.lwac.http.RequestCorrelationId;
import com.ericsson.lwac.http.SigningServerRequestWrapper;
import com.ericsson.lwac.http.SigningServerResponseWrapper;
import com.ericsson.lwac.http.core.HttpMethodNotAllowedException;
import com.ericsson.lwac.http.core.security.SigningChallenge;
import com.ericsson.lwac.http.security.ServerSignerProvider;
import com.ericsson.lwac.http.trace.HttpTraceService;
import com.ericsson.lwac.http.types.HttpOperationPath;
import com.ericsson.lwac.net.http.BufferedHttpServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class HttpOperationHandler {
    private final RequestCorrelationId correlationId;
    protected final ServerSignerProvider signerProvider;
    protected final List<HttpOperationServiceListener> listeners;
    protected final HttpTraceService traceService;

    public HttpOperationHandler(RequestCorrelationId correlationId, ServerSignerProvider signerProvider, List<HttpOperationServiceListener> listeners, HttpTraceService traceService) {
        this.correlationId = correlationId;
        this.signerProvider = signerProvider;
        this.listeners = listeners;
        this.traceService = traceService;
    }

    public CompletableFuture<Void> handle(HttpOperationPath path, HttpOperationCallContext httpCallContext, HttpOperationBase operation, Map<String, String> headers) {
        HttpServletRequest request = httpCallContext.getRealRequest();
        HttpServletResponse response = httpCallContext.getRealResponse();
        CallContext callContext = (CallContext)httpCallContext;
        BufferedHttpServletRequest requestWrapper = callContext.getRequestWrapper();
        String operationName = operation.getName();
        String context = path.getContext();
        String sessionContextName = String.format("http-%s", context);
        String signature = callContext.getRequest().getHeader("X-Signature");
        SigningChallenge challenge = this.signerProvider != null ? this.signerProvider.verifyMessage(new SigningServerRequestWrapper(requestWrapper), operation) : null;
        for (HttpOperationServiceListener listener : this.listeners) {
            listener.onRequestReceived(context, operationName);
        }
        try {
            HttpOperationRequest.HttpMethod httpMethod;
            try {
                httpMethod = HttpOperationRequest.HttpMethod.valueOf(callContext.getRequest().getMethod());
            }
            catch (IllegalArgumentException e) {
                throw new HttpMethodNotAllowedException("HTTP method not supported");
            }
            HttpOperationResponse httpOperationResponseImpl = HttpOperationResponse.newBuilder().outputStream(callContext.getResponseOutputStream()).build();
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (Map.Entry<String, String[]> parameter : request.getParameterMap().entrySet()) {
                parameters.put(parameter.getKey(), parameter.getValue()[0]);
            }
            HttpOperationRequest.HttpOperationRequestBuilder httpOperationRequestBuilder = HttpOperationRequest.newBuilder().inputStream(callContext.getRequest().getInputStream()).signature(signature).contentType(request.getContentType()).context(sessionContextName).httpOperationPath(path).httpMethod(httpMethod).headers(headers).parameters(parameters).remoteHost(request.getRemoteHost()).sessionId(callContext.getSessionId());
            if (operation instanceof HttpOperation) {
                ((HttpOperation)operation).handle(this.correlationId, httpOperationRequestBuilder.build(), httpOperationResponseImpl);
                httpOperationResponseImpl.getHeaders().forEach((k, v) -> callContext.getRealResponse().addHeader((String)k, (String)v));
                httpOperationResponseImpl.getOutputStream().flush();
                callContext.getResponseOutputStream().flipBuffers();
                if (this.signerProvider != null) {
                    this.signerProvider.signMessage(new SigningServerResponseWrapper(response, callContext.getResponseOutputStream()), operation, challenge);
                }
                response.setContentType(operation.getContentType());
                this.setResponseStatus(response, httpOperationResponseImpl.getHttpResponseCode().getHttpStatusCode());
                return CompletableFuture.completedFuture(null);
            }
            return ((AsyncHttpOperation)operation).handleAsync(this.correlationId, httpOperationRequestBuilder.build(), httpOperationResponseImpl).thenAccept(vo -> {
                httpOperationResponseImpl.getHeaders().forEach((k, v) -> callContext.getRealResponse().addHeader((String)k, (String)v));
                callContext.getResponseOutputStream().flipBuffers();
                if (this.signerProvider != null) {
                    this.signerProvider.signMessage(new SigningServerResponseWrapper(response, callContext.getResponseOutputStream()), operation, challenge);
                }
                response.setContentType(operation.getContentType());
                this.setResponseStatus(response, httpOperationResponseImpl.getHttpResponseCode().getHttpStatusCode());
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            CompletableFuture<Void> failed = new CompletableFuture<Void>();
            failed.completeExceptionally(e);
            return failed;
        }
    }

    public void setResponseStatus(HttpServletResponse response, int code) {
        response.setStatus(code);
        this.traceService.setStatus(code);
    }

    public void finishResponse(HttpOperationCallContext callContext) throws IOException {
        callContext.finishResponse();
    }
}

