/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import com.ericsson.lwac.http.cli.HttpSettingsFileUtils;
import com.ericsson.lwac.http.cli.SimpleComparator;
import com.ericsson.lwac.http.statistics.Context;
import com.ericsson.lwac.http.statistics.HttpOperationStatistics;
import com.ericsson.lwac.http.statistics.OperationContextInfo;
import com.ericsson.lwac.utilities.cli.ConsoleHelper;
import com.ericsson.lwac.utilities.cli.table.CLIHeaders;
import com.ericsson.lwac.utilities.cli.table.CLITable;
import jakarta.ejb.EJB;
import jakarta.validation.constraints.Pattern;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Command(name="http-operation")
@Parameters(separators="=")
@RemoteCommand
public class HttpOperationsCommand {
    @EJB
    private HttpOperationStatistics statistics;
    private PrintWriter out;

    private void confirmIfDeprecated(OperationContextInfo info, boolean force) throws ExecutionException {
        String line;
        if (info.isDeprecated() && !force && ((line = ConsoleHelper.read("Operation is deprecated, please confirm if it should be added [y/n]")) == null || !line.startsWith("y") && !line.startsWith("Y"))) {
            throw new ExecutionException("Deprecated operation not added. No changes made to the system");
        }
    }

    private void addClassToService(RemoteCLIEnvironment environment, String className, String service) throws IOException {
        environment.updateConfigMap(environment.getApplicationName() + "-services", path -> {
            boolean foundit = Files.list(path).filter(p -> p.getFileName().toString().endsWith(".xml")).map(Path::toFile).anyMatch(file -> {
                try {
                    String xpath = String.format("s:services/s:service[@name='%s']", service);
                    List<Element> list = HttpSettingsFileUtils.processXPathOn(file, xpath, true);
                    if (!list.isEmpty()) {
                        Element serviceElement = list.get(0);
                        Element propertyList = HttpSettingsFileUtils.findElement("p:properties/p:property-list[@name='OperationClasses' and @type='String']", serviceElement);
                        if (propertyList == null) {
                            throw new UncheckedExecutionException("Service lacking operation classes: " + service);
                        }
                        Element found = HttpSettingsFileUtils.findElement("p:property[@value='" + className + "']", propertyList);
                        if (found != null) {
                            String msg = String.format("Service %s already contains operation %s.%nNo changes made to the system.", service, className);
                            throw new UncheckedExecutionException(msg);
                        }
                        Document ownerDocument = propertyList.getOwnerDocument();
                        this.stripWhiteSpace(ownerDocument);
                        Element propertyElement = ownerDocument.createElementNS("http://www.ericsson.com/lwac/properties", "p:property");
                        propertyElement.setAttribute("value", className);
                        propertyList.appendChild(propertyElement);
                        this.sortPropertiesByValue(propertyList);
                        this.saveFile((File)file, ownerDocument);
                        this.out.printf("Added operation %s to service %s%n", className, service);
                        return true;
                    }
                }
                catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
                    throw new UncheckedExecutionException("Could not process file " + file, e);
                }
                return false;
            });
            if (!foundit) {
                String msg = String.format("Service %s not found.%nNo changes made to the system.", service);
                throw new UncheckedExecutionException(msg);
            }
            return true;
        });
    }

    private void stripWhiteSpace(Document ownerDocument) throws XPathExpressionException {
        List<Node> emptyTextNodes = HttpSettingsFileUtils.findMultipleNodes("//text()[string-length(normalize-space(.))=0]", ownerDocument);
        for (Node node : emptyTextNodes) {
            node.getParentNode().removeChild(node);
        }
    }

    private void sortPropertiesByValue(Element owner) {
        NodeList elements = owner.getElementsByTagName("p:property");
        int length = elements.getLength();
        ArrayList<Element> nodes = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Element item = (Element)elements.item(i);
            nodes.add(item);
        }
        nodes.sort(SimpleComparator.compare().thenComparing(e -> e.getAttribute("value")));
        for (Element element : nodes) {
            owner.removeChild(element);
            owner.appendChild(element);
        }
    }

    private void saveFile(File file, Document document) throws IOException, TransformerException {
        try (FileOutputStream dest = new FileOutputStream(file);){
            Transformer transformer1 = TransformerFactory.newInstance().newTransformer();
            transformer1.setOutputProperty("omit-xml-declaration", "no");
            transformer1.setOutputProperty("method", "xml");
            transformer1.setOutputProperty("indent", "yes");
            transformer1.setOutputProperty("encoding", "UTF-8");
            transformer1.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer1.transform(new DOMSource(document), new StreamResult(dest));
        }
    }

    private void setupEnvironment(RemoteCLIEnvironment environment) {
        this.out = environment.getOutputWriter();
    }

    private static class UncheckedExecutionException
    extends RuntimeException {
        public UncheckedExecutionException(String message) {
            super(message);
        }

        public UncheckedExecutionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Command(name="add-class")
    @Parameters(separators="=")
    private class AddClassCommand
    implements RemoteAction {
        @Pattern(regexp="^(?:[a-zA-Z][a-zA-Z0-9_]*+(?:[.][a-zA-Z][a-zA-Z0-9_]*+)*)*$", message="should be a regular Java class name, not an inner or anonymous class.")
        @Parameter(description="The class name of the operation to add", required=true, names={"-c", "--class"})
        private @Pattern(regexp="^(?:[a-zA-Z][a-zA-Z0-9_]*+(?:[.][a-zA-Z][a-zA-Z0-9_]*+)*)*$", message="should be a regular Java class name, not an inner or anonymous class.") String className;
        @Pattern(regexp="^java:/[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an existing LWAC service name (e.g. \"java:/ExampleService\").")
        @Parameter(description="Where to add the operation", required=true, names={"-s", "--service"})
        private @Pattern(regexp="^java:/[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an existing LWAC service name (e.g. \"java:/ExampleService\").") String service;
        @Parameter(description="Add operation, even if deprecated, without confirmation", names={"-f", "--force"})
        private boolean force = false;

        private AddClassCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            HttpOperationsCommand.this.setupEnvironment(environment);
            OperationContextInfo info = HttpOperationsCommand.this.statistics.getOperationInfoByOperationClass(this.className);
            if (info == null) {
                throw new ExecutionException("Unrecognized http operation class: " + this.className);
            }
            HttpOperationsCommand.this.confirmIfDeprecated(info, this.force);
            try {
                HttpOperationsCommand.this.addClassToService(environment, this.className, this.service);
            }
            catch (UncheckedExecutionException | IOException e) {
                throw new ExecutionException("Failed adding service", e);
            }
        }
    }

    @Command(name="add")
    @Parameters(separators="=")
    private class AddCommand
    implements RemoteAction {
        @Pattern(regexp="^(?:[\\p{IsAlphabetic}\\p{IsDigit}_]*+(?:[.][\\p{IsAlphabetic}\\p{IsDigit}_]*+)*)*$", message="should be a string consisting of alphanumeric characters, optionally separated by dots.")
        @Parameter(description="The name of the operation to add", required=true, names={"-o", "--operation"})
        private @Pattern(regexp="^(?:[\\p{IsAlphabetic}\\p{IsDigit}_]*+(?:[.][\\p{IsAlphabetic}\\p{IsDigit}_]*+)*)*$", message="should be a string consisting of alphanumeric characters, optionally separated by dots.") String operation;
        @Pattern(regexp="^[1-9][0-9]?\\.[0-9][0-9]?+$", message="should be a version in the form m.n, where 0 < m < 100 and 0 <= n < 100.")
        @Parameter(description="The version of the operation to add", required=true, names={"-v", "--version"})
        private @Pattern(regexp="^[1-9][0-9]?\\.[0-9][0-9]?+$", message="should be a version in the form m.n, where 0 < m < 100 and 0 <= n < 100.") String version;
        @Pattern(regexp="^java:/[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an existing LWAC service name (e.g. \"java:/ExampleService\").")
        @Parameter(description="Where to add the operation", required=true, names={"-s", "--service"})
        private @Pattern(regexp="^java:/[a-zA-Z][a-zA-Z0-9_-]*$", message="should be an existing LWAC service name (e.g. \"java:/ExampleService\").") String service;
        @Parameter(description="Add operation, even if deprecated, without confirmation", names={"-f", "--force"})
        private boolean force = false;

        private AddCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            HttpOperationsCommand.this.setupEnvironment(environment);
            String operationVersion = this.operation + "/" + this.version;
            List<OperationContextInfo> listOfInfos = HttpOperationsCommand.this.statistics.getOperationInfoByOperationNameAndVersion(this.operation, this.version);
            if (listOfInfos.isEmpty()) {
                throw new ExecutionException("Unknown version of operation " + operationVersion);
            }
            if (listOfInfos.size() > 1) {
                HttpOperationsCommand.this.out.println("Ambiguous operation: " + operationVersion);
                HttpOperationsCommand.this.out.println("Please select one of the alternatives: ");
                listOfInfos.forEach(i -> HttpOperationsCommand.this.out.println(i.getClassName()));
                HttpOperationsCommand.this.out.println("No changes made to the system.");
            } else {
                OperationContextInfo info = listOfInfos.get(0);
                HttpOperationsCommand.this.confirmIfDeprecated(info, this.force);
                try {
                    HttpOperationsCommand.this.addClassToService(environment, info.getClassName(), this.service);
                }
                catch (UncheckedExecutionException | IOException e) {
                    throw new ExecutionException("Failed adding service", e);
                }
            }
        }
    }

    @Command(name="list")
    @Parameters(separators="=")
    private class ListCommand
    implements RemoteAction {
        @Parameter(description="Also include deprecated operations that are unused by a context", names={"-a", "--all"})
        private boolean includeAll = false;
        @Parameter(description="Also include the namespace of requests used by XML operations", names={"-n", "--namespace"})
        private boolean includeNamespace = false;
        private CLITable.Builder table;
        private int rowCount = 0;

        private ListCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            HttpOperationsCommand.this.setupEnvironment(environment);
            List<OperationContextInfo> allOperations = HttpOperationsCommand.this.statistics.getAllOperations();
            allOperations.sort(SimpleComparator.compare().thenComparing(OperationContextInfo::getOperationName).thenComparing(OperationContextInfo::getClassName));
            if (!this.includeAll) {
                allOperations = allOperations.stream().filter(op -> !op.isDeprecated() || !op.getContexts().isEmpty()).collect(Collectors.toList());
            }
            this.table = CLITable.create().name("XML/HTTP Operations").header(this.cliHeaders());
            allOperations.forEach(this::addToTable);
            HttpOperationsCommand.this.out.println(this.table.build());
            HttpOperationsCommand.this.out.flush();
        }

        private CLIHeaders cliHeaders() {
            if (this.includeNamespace) {
                return new CLIHeaders("operation", "depr", "class name", "namespace", "contexts");
            }
            return new CLIHeaders("operation", "depr", "class name", "contexts");
        }

        private void tableRow(String op, String depr, String clazz, String namespace, String ctx) {
            if (this.includeNamespace) {
                this.table.row(op, depr, clazz, namespace, ctx);
            } else {
                this.table.row(op, depr, clazz, ctx);
            }
        }

        private void addToTable(OperationContextInfo op) {
            String allContexts = op.getContexts().stream().sorted().map(Context::getContext).collect(Collectors.joining(","));
            String operationName = op.getOperationName();
            String isDeprecated = op.isDeprecated() ? "D" : "";
            String className = op.getClassName();
            String namespace = op.getNamespace();
            this.tableRow(operationName, isDeprecated, className, namespace, allContexts);
            if (++this.rowCount % 5 == 0) {
                this.tableRow("--------------------------", "", "", "", "");
            }
        }
    }
}

