/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.types;

import java.io.Serializable;

public final class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Version DEFAULT_VERSION = new Version(1, 0);
    public static final int MAX_MAJOR_VERSION = 99;
    public static final int MIN_MAJOR_VERSION = 0;
    public static final int MAX_MINOR_VERSION = 99;
    public static final int MIN_MINOR_VERSION = 0;
    private final short majorVersion;
    private final short minorVersion;
    private final String cached;

    public Version(String version) {
        String[] versions = version.split("\\.");
        if (versions.length != 2) {
            throw new IllegalArgumentException("Version not in MM.mm format");
        }
        this.majorVersion = Short.parseShort(versions[0]);
        this.minorVersion = Short.parseShort(versions[1]);
        this.verifyFormat();
        this.cached = this.majorVersion + "." + this.minorVersion;
    }

    public Version(int majorVersion, int minorVersion) {
        this.verifyMajor(majorVersion);
        this.verifyMinor(minorVersion);
        this.majorVersion = (short)majorVersion;
        this.minorVersion = (short)minorVersion;
        this.cached = majorVersion + "." + minorVersion;
    }

    public static Version fromString(String version) {
        return new Version(version);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int compareTo(Version other) {
        int majorDiff = this.majorVersion - other.majorVersion;
        return majorDiff == 0 ? this.minorVersion - other.minorVersion : majorDiff;
    }

    public boolean equals(Object other) {
        if (other instanceof Version) {
            Version otherVersion = (Version)other;
            return this.majorVersion == otherVersion.majorVersion && this.minorVersion == otherVersion.minorVersion;
        }
        return false;
    }

    public int hashCode() {
        return this.cached.hashCode();
    }

    public String toString() {
        return this.cached;
    }

    private void verifyMajor(int major) {
        if (major < 0 || major > 99) {
            throw new IllegalArgumentException(String.format("Illegal version format. Major version must be between %d and %d", 0, 99));
        }
    }

    private void verifyMinor(int minor) {
        if (minor < 0 || minor > 99) {
            throw new IllegalArgumentException(String.format("Illegal version format. Minor version must be between %d and %d", 0, 99));
        }
    }

    private void verifyFormat() {
        this.verifyMajor(this.majorVersion);
        this.verifyMinor(this.minorVersion);
    }
}

