/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.http.validation;

import com.ericsson.lwac.ObjectHelperFactory;
import com.ericsson.lwac.ValidationException;
import com.ericsson.lwac.deployer.AnnotationListener;
import com.ericsson.lwac.deployer.interceptor.Interceptor;
import com.ericsson.lwac.deployer.interceptor.InterceptorException;
import com.ericsson.lwac.deployer.interceptor.InterceptorHelper;
import com.ericsson.lwac.http.validation.Validate;
import com.ericsson.lwac.utilities.UrlClassPathResourceMessageInterpolator;
import jakarta.validation.Configuration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationInterceptor
implements Interceptor<Void>,
AnnotationListener {
    private static final Logger log = LoggerFactory.getLogger(ValidationInterceptor.class);
    private final Set<Method> validationMethods = new CopyOnWriteArraySet<Method>();
    private static final Validator validator;

    public ValidationInterceptor(Class<?> beanClass, List<Class<?>> interfaceClasses) throws NoSuchMethodException {
        InterceptorHelper interceptorHelper = ObjectHelperFactory.createInterceptorHelper();
        interceptorHelper.processAnnotations(beanClass, interfaceClasses, this);
    }

    @Override
    public Optional<Void> before(Method method, Object ... arguments) throws InterceptorException {
        if (this.validationMethods.contains(method)) {
            ValidationException validationException = null;
            for (Object argument : arguments) {
                int index;
                if (argument instanceof Collection) {
                    Collection collArg = (Collection)argument;
                    index = 0;
                    for (Object argVal : collArg) {
                        Set<ConstraintViolation<Object>> constraintViolations = validator.validate(argVal, new Class[0]);
                        if (!constraintViolations.isEmpty()) {
                            validationException = this.constructException(validationException, argument, constraintViolations, index);
                        }
                        ++index;
                    }
                } else if (argument instanceof Object[]) {
                    Object[] arrArg = (Object[])argument;
                    index = 0;
                    for (Object arrVal : arrArg) {
                        Set<ConstraintViolation<Object>> constraintViolations = validator.validate(arrVal, new Class[0]);
                        if (!constraintViolations.isEmpty()) {
                            validationException = this.constructException(validationException, argument, constraintViolations, index);
                        }
                        ++index;
                    }
                } else {
                    Set<ConstraintViolation<Object>> constraintViolations = validator.validate(argument, new Class[0]);
                    if (!constraintViolations.isEmpty()) {
                        validationException = this.constructException(argument, constraintViolations);
                    }
                }
                if (validationException == null) continue;
                throw validationException;
            }
        }
        return Optional.empty();
    }

    private ValidationException constructException(Object argument, Set<ConstraintViolation<Object>> constraintViolations) {
        return this.constructException(null, argument, constraintViolations, -1);
    }

    private ValidationException constructException(ValidationException exception, Object argument, Set<ConstraintViolation<Object>> constraintViolations, int index) {
        ValidationException validationException;
        if (exception == null) {
            String errorMessage = String.format("Request: %s violates constraints!", argument.getClass().getSimpleName());
            validationException = new ValidationException(errorMessage);
        } else {
            validationException = exception;
        }
        for (ConstraintViolation<Object> violation : constraintViolations) {
            StringBuilder propertyName = new StringBuilder(64);
            if (index >= 0) {
                propertyName.append("[");
                propertyName.append(index);
                propertyName.append("].");
            }
            propertyName.append(this.findXmlElementName(violation));
            String propertyNameString = propertyName.toString();
            validationException.getArguments().put(propertyNameString, violation.getMessage());
        }
        return validationException;
    }

    @Override
    public void onAnnotationFound(Class<?> beanClass, Method beanMethod, Method interfaceMethod, Annotation annotation) {
        if (annotation instanceof Validate) {
            this.validationMethods.add(interfaceMethod);
        }
    }

    private String findXmlElementName(ConstraintViolation<?> violation) {
        String xmlPathString;
        try {
            Object rootBean = violation.getRootBean();
            Class<?> beanClass = rootBean.getClass();
            Path propertyPath = violation.getPropertyPath();
            xmlPathString = this.buildFromPropertyPath(beanClass, propertyPath);
        }
        catch (NoSuchFieldException e) {
            xmlPathString = violation.getPropertyPath().toString();
        }
        catch (SecurityException e) {
            xmlPathString = violation.getPropertyPath().toString();
            log.warn("Not allowed to locate the violating field '" + violation.getPropertyPath().toString() + "' in '" + violation.getRootBean().getClass().getCanonicalName() + "'", e);
        }
        return xmlPathString;
    }

    private String buildFromPropertyPath(Class<?> beanClass, Path propertyPath) throws NoSuchFieldException, SecurityException {
        StringBuilder builder = new StringBuilder(64);
        boolean first = true;
        Class workingBeanClass = beanClass;
        for (Path.Node node : propertyPath) {
            String nodeName = node.getName();
            if (nodeName != null) {
                if (!first) {
                    if (node.isInIterable()) {
                        builder.append('[');
                        if (node.getIndex() != null) {
                            builder.append(node.getIndex());
                        } else if (node.getKey() != null) {
                            builder.append(node.getKey());
                        }
                        builder.append(']');
                    }
                    builder.append('.');
                }
                if (nodeName.startsWith("[")) {
                    builder.append(this.lookupArray(workingBeanClass, nodeName));
                } else {
                    Field field = workingBeanClass.getDeclaredField(node.getName());
                    if (field.getAnnotation(XmlValue.class) != null && !builder.toString().endsWith("].")) {
                        builder.replace(builder.length() - 1, builder.length(), "");
                    } else {
                        builder.append(this.lookupXmlName(field));
                    }
                    Type type = field.getGenericType();
                    if (type instanceof ParameterizedType) {
                        ParameterizedType pType = (ParameterizedType)type;
                        workingBeanClass = (Class)pType.getActualTypeArguments()[0];
                    } else {
                        workingBeanClass = field.getType();
                    }
                }
            }
            first = false;
        }
        return builder.toString();
    }

    private String lookupArray(Class<?> beanClass, String nodeName) {
        StringBuilder builder = new StringBuilder(64);
        String[] variables = nodeName.substring(1, nodeName.length() - 1).split("[,]");
        boolean first = true;
        builder.append('[');
        for (String variable : variables) {
            if (!first) {
                builder.append(',');
            }
            try {
                Field field = beanClass.getDeclaredField(variable);
                builder.append(this.lookupXmlName(field));
            }
            catch (NoSuchFieldException | SecurityException e) {
                builder.append(variable.toLowerCase());
                log.warn("Variable not found in ValidationInterceptor: {}", (Object)variable);
            }
            first = false;
        }
        builder.append(']');
        return builder.toString();
    }

    private String lookupXmlName(Field field) {
        XmlElementWrapper xmlElementWrapper = field.getAnnotation(XmlElementWrapper.class);
        XmlElement xmlElement = field.getAnnotation(XmlElement.class);
        XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
        if (xmlElementWrapper != null) {
            return xmlElementWrapper.name();
        }
        if (xmlElement != null) {
            return xmlElement.name();
        }
        if (xmlAttribute != null) {
            return xmlAttribute.name();
        }
        return field.getName().toLowerCase();
    }

    static {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        config.messageInterpolator(new UrlClassPathResourceMessageInterpolator());
        ValidatorFactory factory = config.buildValidatorFactory();
        validator = factory.getValidator();
    }
}

