/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.security.authorization;

import com.ericsson.lwac.validators.IsURL;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/lwac/security/authorization/common", name="urlvalue")
public class UrlValue {
    private static final long serialVersionUID = 1L;
    @Max(value=256L)
    @Min(value=8L)
    @IsURL
    @NotNull
    @NotBlank
    @XmlValue
    private final @Max(value=256L) @Min(value=8L) @NotNull @NotBlank String value;

    private UrlValue() {
        this.value = null;
    }

    private UrlValue(String value) {
        this.value = value;
    }

    public String getValueAsString() {
        return this.value;
    }

    public static Optional<String> asString(UrlValue value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(value.getValueAsString());
    }

    public static UrlValue fromString(String value) {
        return value == null ? null : new UrlValue(value);
    }
}

