/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.statistics;

import com.ericsson.lwac.statistics.Statistics;
import com.ericsson.lwac.statistics.StatisticsName;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CollectedStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StatisticsName statisticsName;
    private final List<Statistics> statistics;
    private final LocalDateTime since;

    protected CollectedStatistics(Builder builder) {
        this.statisticsName = builder.statisticsName;
        this.statistics = Collections.unmodifiableList(builder.statistics);
        this.since = builder.since;
    }

    public StatisticsName getStatisticsName() {
        return this.statisticsName;
    }

    public List<Statistics> getStatistics() {
        return this.statistics;
    }

    public LocalDateTime getSince() {
        return this.since;
    }

    public boolean isEmpty() {
        return this.statistics.isEmpty();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private StatisticsName statisticsName;
        private List<Statistics> statistics = new ArrayList<Statistics>();
        private LocalDateTime since;

        public Builder name(StatisticsName statisticsName) {
            this.statisticsName = statisticsName;
            return this;
        }

        public Builder since(LocalDateTime since) {
            this.since = since;
            return this;
        }

        public Builder statistics(Iterable<Statistics> statistics) {
            if (statistics != null) {
                statistics.forEach(this.statistics::add);
            }
            return this;
        }

        public CollectedStatistics build() {
            return new CollectedStatistics(this);
        }
    }
}

