/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.statistics;

import com.ericsson.lwac.statistics.StatisticsName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Statistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final StatisticsName statisticsName;
    private final Map<StatisticsName, String> parameters;
    private final List<Statistics> subStatistics;
    private final boolean hidden;

    protected Statistics(Builder builder) {
        this.statisticsName = builder.statisticsName;
        this.parameters = builder.parameters;
        this.subStatistics = builder.subStatistics;
        this.hidden = builder.hidden;
    }

    public StatisticsName getStatisticsName() {
        return this.statisticsName;
    }

    public Map<StatisticsName, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Collection<Statistics> getSubStatistics() {
        return this.subStatistics;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private StatisticsName statisticsName;
        private final Map<StatisticsName, String> parameters = new HashMap<StatisticsName, String>();
        private final List<Statistics> subStatistics = new LinkedList<Statistics>();
        private boolean hidden = false;

        public Builder name(StatisticsName statisticsName) {
            this.statisticsName = statisticsName;
            return this;
        }

        public Builder name(String name) {
            this.statisticsName = StatisticsName.fromString(name);
            return this;
        }

        public Builder parameters(Map<StatisticsName, String> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, String value) {
            this.parameters.put(statisticsName, value);
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, boolean value) {
            this.parameters.put(statisticsName, value ? "Y" : "N");
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, int value) {
            this.parameters.put(statisticsName, String.valueOf(value));
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, Integer value) {
            if (value != null) {
                this.parameters.put(statisticsName, String.valueOf(value));
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, long value) {
            this.parameters.put(statisticsName, String.valueOf(value));
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, Long value) {
            if (value != null) {
                this.parameters.put(statisticsName, String.valueOf(value));
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, double value) {
            this.parameters.put(statisticsName, String.format("%.3f", value));
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, Double value) {
            if (value != null) {
                this.parameters.put(statisticsName, String.format("%.3f", value));
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, float value) {
            this.parameters.put(statisticsName, String.format("%.3f", Float.valueOf(value)));
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, Float value) {
            if (value != null) {
                this.parameters.put(statisticsName, String.format("%.3f", value));
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, BigDecimal value) {
            this.parameters.put(statisticsName, String.format("%.3f", value));
            return this;
        }

        public Builder parameter(String name, String value) {
            this.parameters.put(StatisticsName.fromString(name), value);
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, LocalDateTime value) {
            if (value != null) {
                return this.parameter(statisticsName, DateTimeFormatter.ISO_DATE_TIME.format(value));
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, LocalDate value) {
            if (value != null) {
                return this.parameter(statisticsName, DateTimeFormatter.ISO_DATE.format(value));
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, Duration value) {
            if (value != null) {
                if (value.toMillis() >= 86400000L) {
                    return this.parameter(statisticsName, value.toDays() + "d");
                }
                if (value.toMillis() >= 3600000L) {
                    return this.parameter(statisticsName, value.toHours() + "h");
                }
                if (value.toMillis() >= 60000L) {
                    return this.parameter(statisticsName, value.toMinutes() + "m");
                }
                return this.parameter(statisticsName, value.getSeconds() + "s");
            }
            return this;
        }

        public Builder parameter(StatisticsName statisticsName, Enum<?> value) {
            if (value != null) {
                return this.parameter(statisticsName, value.name());
            }
            return this;
        }

        public Builder statistics(Statistics statistics) {
            Objects.requireNonNull(statistics, "'statistics' is invalid, can not be null");
            this.subStatistics.add(statistics);
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Statistics build() {
            Objects.requireNonNull(this.statisticsName, "'name' cannot be null!");
            return new Statistics(this);
        }
    }
}

