/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ChecksumUtils {
    private static final int BUFFERSIZE = 1024;

    private ChecksumUtils() {
    }

    public static String calculateChecksum(InputStream inputStream) throws IOException {
        return ChecksumUtils.prepareChecksum(inputStream).toString(16);
    }

    public static String calculateCompleteChecksum(InputStream inputStream) throws IOException {
        StringBuilder checksum = new StringBuilder(ChecksumUtils.prepareChecksum(inputStream).toString(16));
        while (checksum.length() < 40) {
            checksum.insert(0, "0");
        }
        return checksum.toString();
    }

    private static BigInteger prepareChecksum(InputStream inputStream) throws IOException {
        int count;
        DigestInputStream digestInputStream = ChecksumUtils.createDigestInputStream(inputStream);
        BufferedInputStream bis = new BufferedInputStream(digestInputStream);
        byte[] buffer = new byte[1024];
        while ((count = bis.read(buffer)) == buffer.length || count > 0) {
        }
        bis.close();
        return new BigInteger(1, digestInputStream.getMessageDigest().digest());
    }

    public static DigestInputStream createDigestInputStream(InputStream inputStream) {
        DigestInputStream digestInputStream = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            digestInputStream = new DigestInputStream(inputStream, md);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return digestInputStream;
    }
}

