/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class CustomObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classloader;

    public CustomObjectInputStream(InputStream in) throws IOException {
        super(in);
        this.classloader = null;
    }

    public CustomObjectInputStream(InputStream in, ClassLoader classloader) throws IOException {
        super(in);
        this.classloader = classloader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> c;
        try {
            c = Class.forName(desc.getName(), false, this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader);
        }
        catch (ClassNotFoundException e) {
            c = super.resolveClass(desc);
        }
        return c;
    }
}

