/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.utilities.UrlClassPathResourceMessageInterpolator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.Validation;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public final class ObjectValidator {
    private static final ObjectValidator instance = new ObjectValidator();
    private final Validator validator;

    private ObjectValidator() {
        HibernateValidatorConfiguration configure = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
        configure.messageInterpolator(new UrlClassPathResourceMessageInterpolator());
        configure.failFast(false);
        ValidatorFactory factory = configure.buildValidatorFactory();
        this.validator = factory.getValidator();
    }

    public static <T> T validate(T o) {
        instance.doValidate(o);
        return o;
    }

    private <T> void doValidate(T value) {
        Set<ConstraintViolation<T>> violations = this.validator.validate(value, new Class[0]);
        if (!violations.isEmpty()) {
            ArrayList<ConstraintViolation<T>> sortedViolations = Lists.newArrayList(violations);
            sortedViolations.sort(Comparator.comparing(ConstraintViolation::getMessageTemplate));
            Iterator iterator = sortedViolations.iterator();
            if (iterator.hasNext()) {
                ConstraintViolation violation = (ConstraintViolation)iterator.next();
                if (violation.getInvalidValue() == null) {
                    Path.Node last = Iterables.getLast(violation.getPropertyPath());
                    throw new ValidationException(last.getName() + " " + violation.getMessage());
                }
                Path.Node last = Iterables.getLast(violation.getPropertyPath());
                Class<?> classOfLeafBean = violation.getLeafBean().getClass();
                throw new ValidationException(last.getName() + " in " + classOfLeafBean.getSimpleName() + " is invalid, " + violation.getMessage());
            }
        }
    }
}

