/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.cli.table;

import com.ericsson.lwac.utilities.cli.table.CLIHeaders;
import com.ericsson.lwac.utilities.cli.table.CLIRow;
import com.ericsson.lwac.utilities.cli.table.CLITuple;
import java.util.LinkedList;
import java.util.List;

public class CLITable {
    private static final String SEPARATOR = " | ";
    private final String name;
    private final String status;
    private final CLIHeaders headers;
    private final List<CLITuple> rows;
    private final boolean addSeparator;

    public static Builder create() {
        return new Builder();
    }

    protected CLITable(String name, String status, CLIHeaders header, List<CLITuple> rows, boolean addSeparator) {
        this.name = name;
        this.status = status;
        this.headers = header;
        this.rows = rows;
        this.addSeparator = addSeparator;
    }

    public String toString() {
        String separator;
        StringBuilder builder = new StringBuilder();
        String indent = "    ";
        int[] spacing = this.getSpacing(indent.length());
        builder.append(System.lineSeparator()).append(this.name);
        if (this.status != null) {
            builder.append(indent).append(this.status);
        }
        builder.append(System.lineSeparator());
        String string = separator = this.addSeparator ? SEPARATOR : "";
        if (this.headers == null || this.rows == null || this.rows.isEmpty()) {
            builder.append("---------------------").append(System.lineSeparator()).append(indent).append("No data available");
        } else {
            builder.append(this.headers.toString(indent, spacing, separator)).append(System.lineSeparator());
            for (CLITuple row : this.rows) {
                builder.append(row.toString(indent, spacing, separator)).append(System.lineSeparator());
            }
        }
        return builder.toString();
    }

    private int[] getSpacing(int indent) {
        int[] spacings = new int[this.headers != null ? this.headers.getNumOfColumns() : 0];
        for (int i = 0; i < spacings.length; ++i) {
            int spacing = 0;
            spacing = this.headers.getWidth(i);
            if (!this.rows.isEmpty()) {
                for (CLITuple row : this.rows) {
                    int current = row.getWidth(i);
                    if (current <= spacing) continue;
                    spacing = current;
                }
            }
            spacings[i] = spacing + indent;
        }
        return spacings;
    }

    public static class Builder {
        private String name;
        private String status;
        private CLIHeaders headers;
        private final List<CLITuple> rows = new LinkedList<CLITuple>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder header(CLIHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder row(String ... row) {
            this.rows.add(new CLIRow(row));
            return this;
        }

        public CLITable build() {
            return new CLITable(this.name, this.status, this.headers, this.rows, false);
        }
    }
}

