/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.console;

import com.ericsson.lwac.statistics.StatisticsName;
import com.ericsson.lwac.utilities.console.Column;
import com.ericsson.lwac.utilities.console.ConsoleFormatter;
import com.ericsson.lwac.utilities.console.DefaultRowComparator;
import com.ericsson.lwac.utilities.console.Row;
import com.ericsson.lwac.utilities.console.SortInfo;
import com.ericsson.lwac.utilities.console.TreeTable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TablePrinter {
    private static final String INDENT = "  ";
    private static final Pattern PATTERN_NUMERIC = Pattern.compile("([-+]?\\d+(?:\\.\\d+)?).*");
    private static final String COLUMN_SEPARATOR = "  ";
    private static final Set<String> RED_WORDS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> GREEN_WORDS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final TreeTable table;
    private final Map<Column, ColumnInfo> columnInfo;
    private final SortInfo sortInfo;
    private final boolean colorize;

    private TablePrinter(Builder builder) {
        this.table = builder.treeTable;
        this.columnInfo = TablePrinter.getColumnInfo(builder.treeTable);
        this.sortInfo = builder.sortInfo;
        this.colorize = builder.colorize;
    }

    public String print() {
        StringBuilder sb = new StringBuilder(64);
        this.appendTableHeaders(sb);
        sb.append(System.lineSeparator());
        this.appendTableRows(sb);
        return sb.toString();
    }

    private void appendTableRows(StringBuilder sb) {
        List<Row> rows = this.table.getRows();
        this.appendTableRows(0, sb, this.sortRows(rows));
    }

    private List<Row> sortRows(List<Row> rows) {
        if (this.sortInfo == SortInfo.AS_IS) {
            return rows;
        }
        return Ordering.from(new DefaultRowComparator(this.sortInfo)).sortedCopy(rows);
    }

    private void appendTableRows(int level, StringBuilder sb, List<Row> rowsToPrint) {
        for (Row row : rowsToPrint) {
            boolean firstColum = true;
            for (Column column : this.table.getColumns()) {
                if (!firstColum) {
                    sb.append("  ");
                }
                String value = row.getValue(column);
                Optional<ConsoleFormatter.Color> color = this.getColor(value);
                String cellValue = this.getTableCellValue(level, firstColum, column, value);
                if (color.isPresent()) {
                    sb.append(ConsoleFormatter.colorize(cellValue, color.get()));
                } else {
                    sb.append(cellValue);
                }
                firstColum = false;
            }
            sb.append(System.lineSeparator());
            this.appendTableRows(level + 1, sb, this.sortRows(row.getChildren()));
        }
    }

    private Optional<ConsoleFormatter.Color> getColor(String value) {
        if (this.colorize) {
            if (RED_WORDS.contains(value)) {
                return Optional.of(ConsoleFormatter.Color.RED);
            }
            if (GREEN_WORDS.contains(value)) {
                return Optional.of(ConsoleFormatter.Color.GREEN);
            }
        }
        return Optional.empty();
    }

    private String getTableCellValue(int level, boolean firstColum, Column column, String value) {
        if (firstColum) {
            return this.getTableCellValue(column, this.padLeft(value, value.length() + level * "  ".length(), ' '));
        }
        return this.getTableCellValue(column, value);
    }

    private void appendTableHeaders(StringBuilder sb) {
        boolean first = true;
        for (Column column : this.table.getColumns()) {
            if (!first) {
                sb.append("  ");
            }
            if (this.colorize) {
                sb.append(ConsoleFormatter.format(() -> this.getTableCellValue(column, column.getDisplayName()), ConsoleFormatter.Format.BOLD, new ConsoleFormatter.Format[0]));
            } else {
                sb.append(this.getTableCellValue(column, column.getDisplayName()));
            }
            first = false;
        }
    }

    private String getTableCellValue(Column column, String value) {
        switch (column.getAlignment()) {
            case AUTO: {
                if (this.isNumeric(column)) {
                    return this.padLeft(value, this.getWidth(column), ' ');
                }
                return this.padRight(value, this.getWidth(column), ' ');
            }
            case LEFT: {
                return this.padRight(value, this.getWidth(column), ' ');
            }
        }
        return this.padLeft(value, this.getWidth(column), ' ');
    }

    private int getWidth(Column column) {
        ColumnInfo info = this.columnInfo.get(column);
        return info == null ? 0 : info.getWidth();
    }

    private boolean isNumeric(Column column) {
        ColumnInfo info = this.columnInfo.get(column);
        return info != null && info.isNumeric();
    }

    private static boolean isNumeric(Column column, List<Row> rows) {
        for (Row row : rows) {
            String value;
            if (row.hasValue(column) && !PATTERN_NUMERIC.matcher(value = row.getValue(column)).matches()) {
                return false;
            }
            if (TablePrinter.isNumeric(column, row.getChildren())) continue;
            return false;
        }
        return true;
    }

    private static Map<Column, ColumnInfo> getColumnInfo(TreeTable treeTable) {
        ImmutableMap.Builder<Column, ColumnInfo> widths = ImmutableMap.builder();
        for (Column column : treeTable.getColumns()) {
            int width = TablePrinter.getWidth(column, treeTable);
            boolean numeric = TablePrinter.isNumeric(column, treeTable.getRows());
            ColumnInfo columnInfo = new ColumnInfo(width, numeric);
            widths.put(column, columnInfo);
        }
        return widths.build();
    }

    private static int getWidth(Column column, TreeTable treeTable) {
        int width = column.getWidth();
        for (Row row : treeTable.getRows()) {
            if (TablePrinter.isFirst(column, treeTable.getColumns())) {
                width = Math.max(width, TablePrinter.getFirstColumWidth(row, column));
                continue;
            }
            width = Math.max(width, row.getWidth(column));
        }
        return width;
    }

    private static int getFirstColumWidth(Row row, Column column) {
        return row.getWidth(0, "  ".length(), column);
    }

    private static boolean isFirst(Column column, List<Column> columns) {
        return columns != null && !columns.isEmpty() && columns.get(0).equals(column);
    }

    private String padLeft(String src, int count, char padding) {
        Preconditions.checkNotNull(src, "'src' is invalid, can not be null");
        Preconditions.checkArgument(count >= 0 && count >= src.length(), "'count' is invalid, must be >= 0 and <= length of 'src'");
        if (count == src.length()) {
            return src;
        }
        StringBuilder builder = new StringBuilder(count);
        for (int i = src.length(); i < count; ++i) {
            builder.append(padding);
        }
        builder.append(src);
        return builder.toString();
    }

    private String padRight(String src, int count, char padding) {
        Preconditions.checkNotNull(src, "'src' is invalid, can not be null");
        Preconditions.checkArgument(count >= 0 && count >= src.length(), "'count' is invalid, must be >= 0 and <= length of 'src'");
        if (count == src.length()) {
            return src;
        }
        StringBuilder builder = new StringBuilder(count);
        builder.append(src);
        for (int i = src.length(); i < count; ++i) {
            builder.append(padding);
        }
        return builder.toString();
    }

    public static Builder builder(TreeTable treeTable) {
        return new Builder(treeTable);
    }

    static {
        RED_WORDS.addAll(ImmutableSet.of("no", "disconnected", "failure", "failed", "error", "off", new String[]{"offline", "down"}));
        GREEN_WORDS.addAll(ImmutableSet.of("yes", "connected", "success", "succeeded", "on", "online", new String[]{"up"}));
    }

    private static final class ColumnInfo {
        private final int width;
        private final boolean numeric;

        public ColumnInfo(int width, boolean numeric) {
            this.width = width;
            this.numeric = numeric;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumeric() {
            return this.numeric;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.numeric ? 1231 : 1237);
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)obj;
            return this.numeric == other.numeric && this.width == other.width;
        }
    }

    public static final class Builder {
        private final TreeTable treeTable;
        private SortInfo sortInfo = SortInfo.AS_IS;
        private boolean colorize = false;

        public Builder(TreeTable treeTable) {
            Preconditions.checkNotNull(treeTable, "'treeTable' is invalid, can not be null");
            this.treeTable = treeTable;
        }

        public Builder colorize(boolean colorize) {
            this.colorize = colorize;
            return this;
        }

        public Builder sortAscending(String columnName) {
            return this.sortAscending(StatisticsName.fromString(columnName));
        }

        public Builder sortAscending(StatisticsName columnName) {
            this.sortInfo = SortInfo.asc(this.getColumn(columnName));
            return this;
        }

        public Builder sortDescending(String columnName) {
            return this.sortDescending(StatisticsName.fromString(columnName));
        }

        public Builder sortDescending(StatisticsName columnName) {
            this.sortInfo = SortInfo.desc(this.getColumn(columnName));
            return this;
        }

        public TablePrinter build() {
            return new TablePrinter(this);
        }

        private Column getColumn(StatisticsName columnName) {
            Preconditions.checkNotNull(columnName, "'columnName' is invalid, can not be null");
            Optional<Column> column = this.treeTable.getColumns().stream().filter(c -> c.getName().equals(columnName) || c.getDisplayName().equalsIgnoreCase(columnName.getValueAsString())).findFirst();
            if (column.isPresent()) {
                return column.get();
            }
            List sortableColumnNames = this.treeTable.getColumns().stream().flatMap(c -> Stream.of(c.getName().getValueAsString(), c.getDisplayName().toLowerCase())).distinct().collect(Collectors.toList());
            throw new IllegalArgumentException(String.format("Sorted column name '%s' is not part of provided columns, it must be one of: %s", columnName, sortableColumnNames));
        }
    }
}

