/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.csv;

import com.ericsson.lwac.utilities.csv.CSVCodec;
import com.ericsson.lwac.utilities.csv.CSVCodecAdaptor;
import com.ericsson.lwac.utilities.csv.CSVCodecException;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class CSVCodecFactory {
    private CSVCodecFactory() {
    }

    public static CSVCodec create(char delimiter) {
        CSVCodec csvCodec = new CSVCodec(delimiter);
        csvCodec.registerAdaptor(Double.class, new DoubleAdaptor());
        csvCodec.registerAdaptor(Integer.class, new IntegerAdaptor());
        csvCodec.registerAdaptor(Long.class, new LongAdaptor());
        csvCodec.registerAdaptor(BigDecimal.class, new BigDecimalAdaptor());
        csvCodec.registerAdaptor(DateTime.class, new DateTimeAdaptor());
        csvCodec.registerAdaptor(String.class, new StringAdaptor());
        return csvCodec;
    }

    private static class DateTimeAdaptor
    implements CSVCodecAdaptor<DateTime> {
        private static final String DATETIME_FORMAT = "yyyyMMdd'_'HHmmss";

        private DateTimeAdaptor() {
        }

        @Override
        public DateTime decode(String data) throws CSVCodecException {
            DateTimeFormatter fmt = DateTimeFormat.forPattern(DATETIME_FORMAT);
            return data == null || "".equals(data) ? null : fmt.parseDateTime(data);
        }

        @Override
        public String encode(DateTime dateTime) throws CSVCodecException {
            DateTimeFormatter fmt = DateTimeFormat.forPattern(DATETIME_FORMAT);
            return dateTime != null ? fmt.print(dateTime) : "";
        }
    }

    private static class BigDecimalAdaptor
    implements CSVCodecAdaptor<BigDecimal> {
        private BigDecimalAdaptor() {
        }

        @Override
        public BigDecimal decode(String data) throws CSVCodecException {
            return data == null || "".equals(data) ? null : new BigDecimal(data);
        }

        @Override
        public String encode(BigDecimal data) throws CSVCodecException {
            return data != null ? data.toString() : "";
        }
    }

    private static class LongAdaptor
    implements CSVCodecAdaptor<Long> {
        private LongAdaptor() {
        }

        @Override
        public Long decode(String data) throws CSVCodecException {
            return data == null || "".equals(data) ? null : Long.valueOf(Long.parseLong(data));
        }

        @Override
        public String encode(Long data) throws CSVCodecException {
            return data != null ? data.toString() : "";
        }
    }

    private static class IntegerAdaptor
    implements CSVCodecAdaptor<Integer> {
        private IntegerAdaptor() {
        }

        @Override
        public Integer decode(String data) throws CSVCodecException {
            return data == null || "".equals(data) ? null : Integer.valueOf(Integer.parseInt(data));
        }

        @Override
        public String encode(Integer data) throws CSVCodecException {
            return data != null ? data.toString() : "";
        }
    }

    private static class DoubleAdaptor
    implements CSVCodecAdaptor<Double> {
        private DoubleAdaptor() {
        }

        @Override
        public Double decode(String data) throws CSVCodecException {
            return data == null || "".equals(data) ? null : Double.valueOf(Double.parseDouble(data));
        }

        @Override
        public String encode(Double data) throws CSVCodecException {
            return data != null ? data.toString() : "";
        }
    }

    private static class StringAdaptor
    implements CSVCodecAdaptor<String> {
        private StringAdaptor() {
        }

        @Override
        public String decode(String data) throws CSVCodecException {
            return data == null || "".equals(data) ? null : data;
        }

        @Override
        public String encode(String data) throws CSVCodecException {
            return data != null ? data : "";
        }
    }
}

