/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.io;

import com.ericsson.lwac.utilities.Preconditions;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.InputStream;

public final class UnclosableInputStream
extends InputStream {
    private final InputStream inputStream;

    protected UnclosableInputStream(@NotNull InputStream inputStream) {
        Preconditions.assertNotNull(inputStream);
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public void close() throws IOException {
    }

    public static UnclosableInputStream closeProof(@NotNull InputStream inputStream) {
        return new UnclosableInputStream(inputStream);
    }

    public static UnclosableInputStream from(@NotNull InputStream inputStream) {
        return new UnclosableInputStream(inputStream);
    }
}

