/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ChecksumUtils {
    private static final int BUFFERSIZE = 1024;

    public static String calculateChecksum(InputStream inputStream) throws IOException {
        return ChecksumUtils.prepareChecksum(inputStream).toString(16);
    }

    public static String calculateCompleteChecksum(InputStream inputStream) throws IOException {
        String checksum = ChecksumUtils.prepareChecksum(inputStream).toString(16);
        while (checksum.length() < 40) {
            checksum = "0" + checksum;
        }
        return checksum;
    }

    private static BigInteger prepareChecksum(InputStream inputStream) throws IOException {
        DigestInputStream digestInputStream = ChecksumUtils.createDigestInputStream(inputStream);
        BufferedInputStream bis = new BufferedInputStream(digestInputStream);
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = bis.read(buffer)) == buffer.length || count > 0) {
        }
        bis.close();
        return new BigInteger(1, digestInputStream.getMessageDigest().digest());
    }

    public static DigestInputStream createDigestInputStream(InputStream inputStream) {
        MessageDigest md = null;
        DigestInputStream digestInputStream = null;
        try {
            md = MessageDigest.getInstance("SHA1");
            digestInputStream = new DigestInputStream(inputStream, md);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return digestInputStream;
    }

    public static DigestInputStream createDigestInputStream(File file) throws FileNotFoundException {
        return ChecksumUtils.createDigestInputStream(new FileInputStream(file));
    }
}

