/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils.designbycontract;

import com.ericsson.utils.designbycontract.PreconditionViolationException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Preconditions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Preconditions.class);

    private Preconditions() {
    }

    public static void assertNotNull(Object ref) {
        try {
            if (ref == null) {
                throw new NullPointerException();
            }
        }
        catch (NullPointerException x) {
            LOGGER.error("Precondition violation, null reference", x);
            throw x;
        }
    }

    public static void assertNotNull(String message, Object ref) {
        try {
            if (ref == null) {
                throw new NullPointerException(message);
            }
        }
        catch (NullPointerException x) {
            LOGGER.error("Precondition violation, null reference", x);
            throw x;
        }
    }

    public static void assertNotEmpty(Collection<?> collection) {
        Preconditions.assertNotNull(collection);
        try {
            if (collection.isEmpty()) {
                throw new PreconditionViolationException("Precondition violation, collection was empty!");
            }
        }
        catch (RuntimeException x) {
            LOGGER.error("Precondition violation", x);
            throw x;
        }
    }

    public static void assertNotEmpty(String message, Collection<?> collection) {
        Preconditions.assertNotNull(message, collection);
        try {
            if (collection.isEmpty()) {
                throw new PreconditionViolationException(message);
            }
        }
        catch (RuntimeException x) {
            LOGGER.error("Precondition violation", x);
            throw x;
        }
    }

    public static void assertThat(boolean expression) {
        try {
            if (!expression) {
                throw new PreconditionViolationException("Precondition violation, expression not satisfied.");
            }
        }
        catch (RuntimeException x) {
            LOGGER.error("Precondition violation", x);
            throw x;
        }
    }
}

