/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.DigitListDocument;
import com.ericsson.vareditor.document.LimitingDocument;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class RangeCheckingDigitListDocument
extends DigitListDocument {
    private static final Pattern DEFAULT_DELIMITER_PATTERN = Pattern.compile("[ ,\t\n\r]");
    private final int myMaxRangeSize;
    private final boolean myRequireSameRangeEndMagnitude;

    public RangeCheckingDigitListDocument(int maxRangeSize, boolean requireSameRangeEndMagnitude) {
        this(maxRangeSize, requireSameRangeEndMagnitude, DEFAULT_DELIMITER_PATTERN);
    }

    public RangeCheckingDigitListDocument(int maxRangeSize, boolean requireSameRangeEndMagnitude, Pattern delimiterPattern) {
        super(delimiterPattern);
        this.myMaxRangeSize = maxRangeSize;
        this.myRequireSameRangeEndMagnitude = requireSameRangeEndMagnitude;
    }

    @Override
    protected void testRange(String startValueString, String endValueString) throws LimitingDocument.Rejection {
        super.testRange(startValueString, endValueString);
        BigInteger startValue = new BigInteger(startValueString);
        BigInteger endValue = new BigInteger(endValueString);
        if (this.myRequireSameRangeEndMagnitude && startValueString.length() != endValueString.length()) {
            throw new LimitingDocument.Rejection("Start value and end value should have same magnitude in range: " + startValueString + "-" + endValueString);
        }
        if (endValue.subtract(startValue).intValue() + 1 > this.myMaxRangeSize) {
            throw new LimitingDocument.Rejection("Size of range in token: " + startValueString + "-" + endValueString + " is greater than " + this.myMaxRangeSize);
        }
    }
}

