/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.datelist;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.condition.ConditionUtil;
import ericsson.ere.condition.datelist.SpecialDate;
import ericsson.ere.exception.RatingException;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.Debug;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.datelist.DateList.class)
public class DateList
extends AbstractCondition
implements Cloneable {
    public static final String TAG_DATE = "Date";
    public static final int MAX_NUMBER_OF_SPECIALDATES = 10000;
    private List<SpecialDate> myWildcardedDates = new ArrayList<SpecialDate>(0);
    private List<SpecialDate> mySpecialDates = new ArrayList<SpecialDate>(0);

    public DateList clone() {
        try {
            int i;
            ArrayList<SpecialDate> l;
            int len;
            DateList copy = (DateList)super.clone();
            if (this.myWildcardedDates.size() != 0) {
                len = this.myWildcardedDates.size();
                l = new ArrayList<SpecialDate>(len);
                for (i = 0; i < len; ++i) {
                    l.add((SpecialDate)this.myWildcardedDates.get(i).clone());
                }
                copy.myWildcardedDates = l;
            } else {
                copy.myWildcardedDates = new ArrayList<SpecialDate>(0);
            }
            if (this.mySpecialDates.size() != 0) {
                len = this.mySpecialDates.size();
                l = new ArrayList(len);
                l = new ArrayList(len);
                for (i = 0; i < len; ++i) {
                    l.add((SpecialDate)this.mySpecialDates.get(i).clone());
                }
                copy.mySpecialDates = l;
            } else {
                copy.mySpecialDates = new ArrayList<SpecialDate>(0);
            }
            return copy;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("should not happen", x);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateList other = (DateList)obj;
        if (this.mySpecialDates == null ? other.mySpecialDates != null : !this.mySpecialDates.equals(other.mySpecialDates)) {
            return false;
        }
        return !(this.myWildcardedDates == null ? other.myWildcardedDates != null : !this.myWildcardedDates.equals(other.myWildcardedDates));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.mySpecialDates == null ? 0 : this.mySpecialDates.hashCode());
        result = 31 * result + (this.myWildcardedDates == null ? 0 : this.myWildcardedDates.hashCode());
        return result;
    }

    private void addDateToken(String token) throws RatingException {
        if (token.indexOf(42) >= 0) {
            if (token.indexOf(45) >= 0) {
                throw new RatingException(5, "Wildcard dates cannot contain ranges");
            }
            this.addWildcardDate(token);
        } else if (token.indexOf(45) >= 0) {
            this.addDateRange(token);
        } else {
            this.addSpecialDate(token);
        }
    }

    private void addWildcardDate(String token) throws RatingException {
        byte day;
        byte month;
        short year;
        int startPos = 0;
        int endPos = 0;
        if (token.indexOf(42) == 0) {
            ++endPos;
            year = -1;
        } else {
            String yyyy = token.substring(startPos, endPos += 4);
            try {
                year = Short.parseShort(yyyy);
            }
            catch (NumberFormatException x) {
                throw new RatingException(5, "Failed to parse year into YYYY format. Date token: \"" + token + "\". Year part: \"" + yyyy + "\"");
            }
        }
        if (token.charAt(endPos) == '*') {
            ++endPos;
            month = -1;
        } else {
            startPos = endPos;
            String mm = token.substring(startPos, endPos += 2);
            try {
                month = Byte.parseByte(mm);
            }
            catch (NumberFormatException x) {
                throw new RatingException(5, "Failed to parse month into MM format. Date token: \"" + token + "\". Month part: \"" + mm + "\"");
            }
        }
        if (token.charAt(endPos) == '*') {
            ++endPos;
            day = -1;
        } else {
            startPos = endPos;
            String dd = token.substring(startPos, endPos += 2);
            try {
                day = Byte.parseByte(dd);
            }
            catch (NumberFormatException x) {
                throw new RatingException(5, "Failed to parse day into DD format. Date token: \"" + token + "\". Day part: \"" + dd + "\"");
            }
        }
        if (endPos != token.length()) {
            throw new RatingException(5, "Too many characters in token: \"" + token + "\"");
        }
        if (this.myWildcardedDates.size() == 0) {
            this.myWildcardedDates = new ArrayList<SpecialDate>(1);
        }
        this.myWildcardedDates.add(new SpecialDate(year, month, day));
    }

    private void addSpecialDate(String token) throws RatingException {
        byte day;
        byte month;
        short year;
        if (token.length() != 8) {
            throw new RatingException(5, "Failed to parse date token into YYYYMMDD format. Date token: \"" + token + "\".");
        }
        String yyyy = token.substring(0, 4);
        String mm = token.substring(4, 6);
        String dd = token.substring(6, 8);
        try {
            year = Short.parseShort(yyyy);
        }
        catch (NumberFormatException x) {
            throw new RatingException(5, "Failed to parse year into YYYY format. Date token: \"" + token + "\". Year part: \"" + yyyy + "\"");
        }
        try {
            month = Byte.parseByte(mm);
        }
        catch (NumberFormatException x) {
            throw new RatingException(5, "Failed to parse month into MM format. Date token: \"" + token + "\". Month part: \"" + mm + "\"");
        }
        try {
            day = Byte.parseByte(dd);
        }
        catch (NumberFormatException x) {
            throw new RatingException(5, "Failed to parse day into DD format. Date token: \"" + token + "\". Day part: \"" + dd + "\"");
        }
        if (this.mySpecialDates.size() == 0) {
            this.mySpecialDates = new ArrayList<SpecialDate>(1);
        }
        this.mySpecialDates.add(new SpecialDate(year, month, day));
    }

    private void addDateRange(String token) throws RatingException {
        SpecialDate toDate;
        SpecialDate fromDate;
        if (token.length() != 17) {
            throw new RatingException(5, "Failed to parse date range token into yyyymmdd-YYYYMMDD format. Date token: \"" + token + "\".");
        }
        String yyyy = token.substring(0, 4);
        String mm = token.substring(4, 6);
        String dd = token.substring(6, 8);
        String dash = token.substring(8, 9);
        String YYYY = token.substring(9, 13);
        String MM = token.substring(13, 15);
        String DD = token.substring(15, 17);
        if (!"-".equals(dash)) {
            throw new RatingException(5, "Failed to parse date range token into yyyymmdd-YYYYMMDD format. Date token: \"" + token + "\".");
        }
        try {
            fromDate = new SpecialDate(Integer.parseInt(yyyy), Integer.parseInt(mm), Integer.parseInt(dd));
            toDate = new SpecialDate(Integer.parseInt(YYYY), Integer.parseInt(MM), Integer.parseInt(DD));
        }
        catch (Exception x) {
            throw new RatingException(5, "Failed to parse date range token into yyyymmdd-YYYYMMDD format. Date token: \"" + token + "\".");
        }
        if (fromDate.compareTo(toDate) > 0) {
            throw new RatingException(5, "Invalid date range, the start date must be less than the end date. Date token: \"" + token + "\".");
        }
        if (this.mySpecialDates.size() == 0) {
            this.mySpecialDates = new ArrayList<SpecialDate>();
        }
        while (!fromDate.equals(toDate)) {
            this.mySpecialDates.add((SpecialDate)fromDate.clone());
            fromDate.next();
        }
        this.mySpecialDates.add((SpecialDate)toDate.clone());
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        this.setConditionName(XMLUtil.getFirstTextContent(iterator));
        NodeList children = iterator.getChildNodes();
        Element dateNode = XMLUtil.getNamedElement(TAG_DATE, children);
        String dateList = XMLUtil.getFirstTextContent(dateNode);
        if (dateList.length() > 0) {
            StringTokenizer next = new StringTokenizer(dateList, " ,\t\n\r");
            while (next.hasMoreTokens()) {
                String token = next.nextToken();
                if (token.length() <= 0) continue;
                this.addDateToken(token);
            }
            if (this.mySpecialDates.size() != 0) {
                Collections.sort(this.mySpecialDates);
            }
        }
        return this;
    }

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            this.setKey("DayOfWeek");
        } else {
            this.setKey(fieldName);
        }
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        Calendar cal;
        long max = 0L;
        if (theData.useTrace()) {
            theData.getTrace().println("\tCondition : " + this.conditionName);
        }
        if (theData.useDebug()) {
            Debug.debug("Key is set to :" + this.key);
        }
        if (this.key.equals("BuiltInDate")) {
            cal = theData.currentStartDate;
        } else {
            RatingDataField fieldWithDate = ConditionUtil.getField(this.conditionName, this.key, theData);
            fieldWithDate.isUsed(true);
            cal = ConditionUtil.getCalendarValue(this.conditionName, theData.useTrace(), theData.getTrace(), 0, fieldWithDate);
        }
        SpecialDate date = new SpecialDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        if (this.dateIsSpecial(date)) {
            max = this.calcSatisfied(cal);
            if (theData.useTrace()) {
                theData.getTrace().println("\tCondition valid (hh:mm:ss):" + this.longToTime(max) + "( " + max + " seconds)");
            }
            theData.setCurrentMaxDuration(max);
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + date + " => TRUE  (maxDuration = " + theData.currentMaxDuration + ")");
            }
            return true;
        }
        max = this.calcUnsatisfied(cal);
        theData.setCurrentMaxDuration(max);
        if (theData.useTrace()) {
            theData.getTrace().println("\tCondition will be valid after (hh:mm:ss): " + this.longToTime(max) + " ( " + max + " seconds)");
            theData.getTrace().println("\t" + date + " => FALSE  (maxDuration == " + theData.currentMaxDuration + ")");
        }
        return false;
    }

    private long calcSatisfied(Calendar cal) {
        SpecialDate day = new SpecialDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        long hour = cal.get(11);
        long min = cal.get(12);
        long sec = cal.get(13);
        long remaining = 86400L - hour * 60L * 60L - min * 60L - sec;
        boolean isSpecial = this.dateIsSpecial(day.next());
        while (isSpecial) {
            remaining += 86400L;
            isSpecial = this.dateIsSpecial(day.next());
        }
        return remaining;
    }

    private long calcUnsatisfied(Calendar cal) {
        SpecialDate day = new SpecialDate(cal.get(1), cal.get(2) + 1, cal.get(5));
        SpecialDate last = null;
        if (this.mySpecialDates.size() > 0) {
            last = this.mySpecialDates.get(this.mySpecialDates.size() - 1);
        }
        if (this.myWildcardedDates.size() == 0 && last != null && day.compareTo(last) > 0) {
            return Long.MAX_VALUE;
        }
        long hour = cal.get(11);
        long min = cal.get(12);
        long sec = cal.get(13);
        long remaining = 86400L - hour * 60L * 60L - min * 60L - sec;
        day.next();
        boolean isSpecial = this.wildcardMatch(day);
        if (!isSpecial) {
            int found = Collections.binarySearch(this.mySpecialDates, day);
            if (found >= 0) {
                return remaining;
            }
            int nextGreaterIndex = -1 * (found + 1);
            if (nextGreaterIndex == this.mySpecialDates.size()) {
                while (!this.wildcardMatch(day)) {
                    remaining += 86400L;
                    day.next();
                }
            } else {
                SpecialDate nextRegular = this.mySpecialDates.get(nextGreaterIndex);
                while (!day.equals(nextRegular)) {
                    remaining += 86400L;
                    day.next();
                    if (!this.wildcardMatch(day)) continue;
                    return remaining;
                }
            }
        } else {
            return remaining;
        }
        return remaining;
    }

    private boolean wildcardMatch(SpecialDate date) {
        int len = this.myWildcardedDates.size();
        for (int i = 0; i < len; ++i) {
            if (!this.myWildcardedDates.get(i).matches(date)) continue;
            return true;
        }
        return false;
    }

    private boolean dateIsSpecial(SpecialDate date) {
        if (this.wildcardMatch(date)) {
            return true;
        }
        int found = Collections.binarySearch(this.mySpecialDates, date);
        return found >= 0;
    }

    @Override
    public long getConditionSatisfiedDuration(RatingData theData) {
        Calendar cal;
        long max = Long.MAX_VALUE;
        if (this.key.equals("BuiltInDate")) {
            cal = theData.currentStartDate;
        } else {
            try {
                RatingDataField fieldWithDate = ConditionUtil.getField(this.conditionName, this.key, theData);
                fieldWithDate.isUsed(true);
                cal = ConditionUtil.getCalendarValue(this.conditionName, theData.useTrace(), theData.getTrace(), 0, fieldWithDate);
            }
            catch (RatingException x) {
                throw new RuntimeException(x);
            }
        }
        max = this.calcSatisfied(cal);
        return max;
    }

    @Override
    public long getConditionUnsatisfiedDuration(RatingData theData) {
        Calendar cal;
        long max = Long.MAX_VALUE;
        if (this.key.equals("BuiltInDate")) {
            cal = theData.currentStartDate;
        } else {
            try {
                RatingDataField fieldWithDate = ConditionUtil.getField(this.conditionName, this.key, theData);
                fieldWithDate.isUsed(true);
                cal = ConditionUtil.getCalendarValue(this.conditionName, theData.useTrace(), theData.getTrace(), 0, fieldWithDate);
            }
            catch (RatingException x) {
                throw new RuntimeException(x);
            }
        }
        max = this.calcUnsatisfied(cal);
        return max;
    }

    private String longToTime(long time) {
        int hour = (int)time / 3600;
        int min = (int)(time % 3600L) / 60;
        int sec = (int)time % 60;
        return hour + ":" + min + ":" + sec;
    }
}

