/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.string;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.BcdStringVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BcdStringConditionProfile
extends AbstractConditionProfile {
    ClassRepository myRepository;
    private static String LABEL_COMPARATION = "Comparison";
    private static String LABEL_TEXT = "Text";
    private String[] myComparationChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(LABEL_COMPARATION, 0, (Object[])this.myComparationChoices));
        BcdString defaultString = new BcdString("");
        l.add(new BcdStringVariable(LABEL_TEXT, defaultString));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String comp = "0";
        String text = "";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("Comparation") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                comp = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("Text") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            text = value.item(bb).getNodeValue();
        }
        l.add(new DropDownVariable(LABEL_COMPARATION, (Object)comp, 1, this.myComparationChoices));
        l.add(new BcdStringVariable(LABEL_TEXT, text));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_TEXT);
        out.println("<Text>" + text + "</" + "Text" + ">");
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        out.println("<Comparation>" + comp + "</" + "Comparation" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_TEXT);
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARATION);
        comp = comp.equals("-1") ? "Invalid" : this.myComparationChoices[Integer.valueOf(comp)].toLowerCase();
        String info = "<b>" + this.getDescription(variables) + "</b> (" + comp + " " + text + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

