/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.time;

import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import ericsson.ere.xml.XMLUtil;
import java.util.BitSet;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeInCallSegment
extends AbstractCondition {
    public static final String TAG_DENOMINATOR = "Denominator";
    public static final String TAG_REMAINDER = "ModulusResults";
    private long myDenominator = -1L;
    private BitSet myModuloResults = null;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NodeList children = iterator.getChildNodes();
        Element denomNode = XMLUtil.getNamedElement(TAG_DENOMINATOR, children);
        Element remainderNode = XMLUtil.getNamedElement(TAG_REMAINDER, children);
        if (denomNode == null) {
            throw new IllegalArgumentException("Mandatory tag Denominator missing.");
        }
        if (remainderNode == null) {
            throw new IllegalArgumentException("Mandatory tag ModulusResults missing.");
        }
        String denominatorString = XMLUtil.getFirstTextContent(denomNode);
        String remainderString = XMLUtil.getFirstTextContent(remainderNode);
        long denominator = Long.parseLong(denominatorString);
        if (denominator <= 0L || denominator > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Denominator " + denominator + " out of allowed range: [1, " + Integer.MAX_VALUE + "]");
        }
        BitSet remainders = this.stringToBitSet(remainderString, (int)denominator);
        this.myDenominator = denominator;
        this.myModuloResults = remainders;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myDenominator ^ this.myDenominator >>> 32);
        result = 31 * result + (this.myModuloResults == null ? 0 : this.myModuloResults.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeInCallSegment other = (TimeInCallSegment)obj;
        if (this.myDenominator != other.myDenominator) {
            return false;
        }
        return !(this.myModuloResults == null ? other.myModuloResults != null : !this.myModuloResults.equals(other.myModuloResults));
    }

    private BitSet stringToBitSet(String s, int max) {
        BitSet retval = new BitSet(max);
        StringTokenizer tok = new StringTokenizer(s, ",");
        try {
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token.indexOf("-") < 0) {
                    int val = Integer.parseInt(token);
                    if (val >= max) {
                        throw new IllegalArgumentException("Value " + val + " out of range [0," + max + ")");
                    }
                    retval.set(val);
                    continue;
                }
                StringTokenizer dashtok = new StringTokenizer(token, "-");
                String startStr = dashtok.nextToken();
                String endStr = dashtok.nextToken();
                int start = Integer.parseInt(startStr);
                int end = Integer.parseInt(endStr);
                if (start >= max || start < 0) {
                    throw new IllegalArgumentException("Value " + start + " out of range [0," + max + ")");
                }
                if (end >= max || end < 0) {
                    throw new IllegalArgumentException("Value " + end + " out of range [0," + max + ")");
                }
                if (start > end) {
                    throw new IllegalArgumentException("Start value " + start + " larger than end value" + end);
                }
                for (int i = start; i <= end; ++i) {
                    retval.set(i);
                }
            }
        }
        catch (NumberFormatException x) {
            throw new IllegalArgumentException("NumberFormatException: " + x.toString());
        }
        return retval;
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        long remainder = theData.currentDuration % this.myDenominator;
        boolean match = this.myModuloResults.get((int)remainder);
        if (match) {
            long max = this.getConditionSatisfiedDuration(theData);
            theData.setCurrentMaxDuration(max);
            if (theData.useTrace()) {
                String msgString = "\tCondition: Time In Call Segment\n\t'Current time' = " + theData.currentDuration + " [ Denominator = " + this.myDenominator + ", Results = " + this.myModuloResults.toString() + " ]";
                String conditionEvaluation = "\t( " + theData.currentDuration + " MOD " + this.myDenominator + ") == " + this.myModuloResults.toString();
                theData.getTrace().println(msgString + conditionEvaluation);
            }
            return true;
        }
        if (theData.useTrace()) {
            String msgString = "\tCondition: Time In Call Segment\n\t'Current time' = " + theData.currentDuration + " [ Denominator = " + this.myDenominator + ", Results = " + this.myModuloResults.toString() + " ]";
            String conditionEvaluation = "\t( " + theData.currentDuration + " MOD " + this.myDenominator + ") == " + this.myModuloResults.toString();
            theData.getTrace().println(msgString + conditionEvaluation);
        }
        return false;
    }

    @Override
    public long getConditionSatisfiedDuration(RatingData theData) {
        long max = 1L;
        return max;
    }

    @Override
    public long getConditionUnsatisfiedDuration(RatingData theData) {
        long max = 1L;
        return max;
    }
}

