/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.interfaces.AmountFactory;
import java.io.Serializable;

@Immutable
public final class Amount
implements Comparable<Amount>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 706105129953973414L;
    private final RatingDecimal myBalance;
    private final String myCurrency;
    private final transient AmountFactory myAmountFactory;

    private Amount(RatingDecimal parBalance, String parCurrency, AmountFactory parAmountFactory) {
        if (parBalance == null) {
            throw new IllegalArgumentException("parBalance is null!");
        }
        if (parCurrency == null) {
            throw new IllegalArgumentException("parCurrency is null!");
        }
        if (parAmountFactory == null) {
            throw new IllegalArgumentException("parAmountFactory is null!");
        }
        this.myBalance = parBalance;
        this.myCurrency = parCurrency;
        this.myAmountFactory = parAmountFactory;
    }

    public static Amount create(RatingDecimal parBalance, String parCurrency, AmountFactory parAmountFactory) {
        return new Amount(parBalance, parCurrency, parAmountFactory);
    }

    public static Amount create(String defaultValue, AmountFactory parAmountFactory) {
        String currency = defaultValue.substring(0, 3);
        String value = defaultValue.substring(4);
        return new Amount(new RatingDecimal(value), currency, parAmountFactory);
    }

    public final RatingDecimal getBalance() {
        return this.myBalance;
    }

    public final String getCurrency() {
        return this.myCurrency;
    }

    public final RatingDecimal quotient(Amount parAmount) {
        Amount other = this.convertIfNecessary(parAmount);
        return this.myBalance.divide(other.getBalance());
    }

    private Amount convertIfNecessary(Amount parAmount) {
        Amount other = parAmount;
        if (!this.hasMyCurrency(parAmount)) {
            other = this.myAmountFactory.convert(parAmount, this.myCurrency);
        }
        return other;
    }

    private boolean hasMyCurrency(Amount parAmount) {
        return this.myCurrency.equals(parAmount.getCurrency());
    }

    public final Amount add(Amount parAmount) {
        Amount other = this.convertIfNecessary(parAmount);
        return new Amount(this.myBalance.add(other.getBalance()), this.myCurrency, this.myAmountFactory);
    }

    public final Amount deduct(Amount parAmount) {
        Amount other = this.convertIfNecessary(parAmount);
        return new Amount(this.myBalance.subtract(other.getBalance()), this.myCurrency, this.myAmountFactory);
    }

    @Override
    public int compareTo(Amount parAmount) {
        Amount other = this.convertIfNecessary(parAmount);
        return this.myBalance.compareTo(other.getBalance());
    }

    public final Amount abs() {
        return new Amount(this.myBalance.abs(), this.myCurrency, this.myAmountFactory);
    }

    @Deprecated
    public final AmountFactory getFactory() {
        return this.myAmountFactory;
    }

    public String getBalanceString(int scale, int roundingMode) {
        return this.myBalance.isZero() ? "0" : this.myBalance.bigDecimalValue(scale, roundingMode).stripTrailingZeros().toPlainString();
    }

    public String toPlainString(int scale, int roundingMode) {
        return this.myCurrency + " " + this.getBalanceString(scale, roundingMode);
    }

    public String toString() {
        return this.toPlainString(6, 4);
    }

    public boolean isZero() {
        return this.myBalance.isZero();
    }

    public boolean isLessThanZero() {
        return this.myBalance.isLessThanZero();
    }

    public boolean isMoreThanZero() {
        return this.myBalance.isMoreThanZero();
    }

    public boolean isLessThanOrEqualToZero() {
        return this.myBalance.isLessThanOrEqualToZero();
    }

    public boolean isMoreThanOrEqualToZero() {
        return this.myBalance.isMoreThanOrEqualToZero();
    }

    public boolean isLessThan(Amount parAmount) {
        return this.compareTo(parAmount) < 0;
    }

    public boolean isMoreThan(Amount parAmount) {
        return this.compareTo(parAmount) > 0;
    }

    public boolean isLessThanOrEqualTo(Amount parAmount) {
        return this.compareTo(parAmount) <= 0;
    }

    public boolean isMoreThanOrEqualTo(Amount parAmount) {
        return this.compareTo(parAmount) >= 0;
    }

    public boolean isEqualTo(Amount parAmount) {
        return this.compareTo(parAmount) == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myBalance == null ? 0 : this.myBalance.hashCode());
        result = 31 * result + (this.myCurrency == null ? 0 : this.myCurrency.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Amount other = (Amount)obj;
        if (this.myBalance == null ? other.myBalance != null : !this.myBalance.equals(other.myBalance)) {
            return false;
        }
        return !(this.myCurrency == null ? other.myCurrency != null : !this.myCurrency.equals(other.myCurrency));
    }

    public AmountFactory getAmountFactory() {
        return this.myAmountFactory;
    }

    @Deprecated
    public Amount clone() {
        try {
            return (Amount)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

