/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.factory.DefaultAmountFactory;
import ericsson.ere.datatype.interfaces.AmountFactory;

@Immutable
public final class AmountStub
implements LazyEvaluatedValue<Amount> {
    private final String myCurrency;
    private final RatingDecimal myBalance;

    private AmountStub(String currency, RatingDecimal balance) {
        this.myCurrency = currency;
        this.myBalance = balance;
    }

    public static AmountStub create(String value) {
        Amount temp = (Amount)DataType.AMOUNT.parseValue(value);
        if (temp == null) {
            throw new IllegalArgumentException("Invalid amount: " + value);
        }
        return new AmountStub(temp.getCurrency(), temp.getBalance());
    }

    public Amount createAmount(DataSet ds) {
        AmountFactory factory = ds.getAmountFactory();
        if (factory == null) {
            factory = DefaultAmountFactory.getInstance();
        }
        return factory.create(this.myBalance, this.myCurrency);
    }

    public String toString() {
        String balance = this.myBalance.isZero() ? "0" : this.myBalance.bigDecimalValue(6, 4).stripTrailingZeros().toPlainString();
        return this.myCurrency + " " + balance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myBalance == null ? 0 : this.myBalance.hashCode());
        result = 31 * result + (this.myCurrency == null ? 0 : this.myCurrency.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmountStub other = (AmountStub)obj;
        if (this.myBalance == null ? other.myBalance != null : !this.myBalance.equals(other.myBalance)) {
            return false;
        }
        return !(this.myCurrency == null ? other.myCurrency != null : !this.myCurrency.equals(other.myCurrency));
    }

    @Override
    public Amount evaluate(DataSet dataset) {
        return this.createAmount(dataset);
    }
}

