/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype.factory;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.util.AmountUtil;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.interfaces.ExtendedAmountFactory;

public class DefaultAmountFactory
implements ExtendedAmountFactory {
    private static final long serialVersionUID = 2248516795061469531L;
    private static DefaultAmountFactory myFactory = new DefaultAmountFactory();

    public static DefaultAmountFactory getInstance() {
        return myFactory;
    }

    @Override
    public Amount convert(Amount parSource, String parCurrency) {
        return Amount.create(parSource.getBalance(), parCurrency, this);
    }

    @Override
    public Amount create(String parCurrency) {
        return Amount.create(new RatingDecimal("0.0"), parCurrency, this);
    }

    public Amount create(String parValue, String parCurrency) {
        if (parValue.lastIndexOf(" ") == 3) {
            return Amount.create(new RatingDecimal(parValue.substring(4)), parValue.substring(0, 3), this);
        }
        return Amount.create(new RatingDecimal(parValue), parCurrency, this);
    }

    @Override
    public Amount create(RatingDecimal parValue, String parCurrency) {
        return Amount.create(parValue, parCurrency, this);
    }

    private DefaultAmountFactory() {
    }

    private Object readResolve() {
        return myFactory;
    }

    public Amount convert(Amount source, String currency, DataSet dataset) {
        return this.convert(source, currency);
    }

    @Override
    public String[] getCurrencyCodes() {
        Object[] ocodes = AmountUtil.getAllAvailableCurrencyCodes();
        String[] codes = new String[ocodes.length];
        System.arraycopy(ocodes, 0, codes, 0, codes.length);
        return codes;
    }

    @Override
    public String getDefaultCurrencyCode() {
        return AmountUtil.getCurrencyCodeForLocale();
    }
}

